/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slope;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.IPillarLikeBlock;
import xfacthd.framedblocks.common.block.slope.FramedPyramidBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.PillarConnection;

public class FramedConnectingPyramidBlock
extends FramedPyramidBlock {
    public FramedConnectingPyramidBlock(BlockType type) {
        super(type);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PropertyHolder.PILLAR_CONNECTION});
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return ((PlacementStateBuilder)PlacementStateBuilder.of(this, super.getStateForPlacement(ctx), ctx).withCustom((state, modCtx) -> {
            Direction side = (Direction)state.getValue((Property)BlockStateProperties.FACING);
            PillarConnection connection = FramedConnectingPyramidBlock.computeConnection((BlockGetter)modCtx.getLevel(), modCtx.getClickedPos(), side);
            return (BlockState)state.setValue(PropertyHolder.PILLAR_CONNECTION, (Comparable)((Object)connection));
        })).build();
    }

    @Override
    protected BlockState updateShape(BlockState state, Direction side, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (side == state.getValue((Property)BlockStateProperties.FACING)) {
            PillarConnection connection = FramedConnectingPyramidBlock.computeConnection((BlockGetter)level, pos, side);
            state = (BlockState)state.setValue(PropertyHolder.PILLAR_CONNECTION, (Comparable)((Object)connection));
        }
        return super.updateShape(state, side, facingState, level, pos, facingPos);
    }

    public static PillarConnection computeConnection(BlockGetter level, BlockPos pos, Direction side) {
        BlockState state = level.getBlockState(pos.relative(side));
        Block block = state.getBlock();
        if (block instanceof IPillarLikeBlock) {
            IPillarLikeBlock block2 = (IPillarLikeBlock)block;
            return block2.getPillarConnection(state, side.getOpposite());
        }
        if (Utils.isY(side)) {
            if (state.is(BlockTags.FENCES)) {
                return PillarConnection.POST;
            }
            if (state.is(BlockTags.WALLS) && state.hasProperty((Property)WallBlock.UP) && ((Boolean)state.getValue((Property)WallBlock.UP)).booleanValue()) {
                return PillarConnection.PILLAR;
            }
        }
        return PillarConnection.NONE;
    }
}

