/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.util;

import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.util.Lazy;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.client.util.FramedClientUtils;

public final class KeyMappings {
    public static final String KEY_CATEGORY = "framedblocks.key.categories.framedblocks";
    public static final Lazy<KeyMapping> KEYMAPPING_UPDATE_CULLING = KeyMappings.makeKeyMapping("update_cull", 298);
    public static final Lazy<KeyMapping> KEYMAPPING_WIPE_CACHE = KeyMappings.makeKeyMapping("wipe_cache", -1);

    private static Lazy<KeyMapping> makeKeyMapping(String name, int key) {
        return Lazy.of(() -> new KeyMapping("framedblocks.key." + name, key, KEY_CATEGORY));
    }

    public static void onClientTick(ClientTickEvent.Pre event) {
        BlockHitResult blockHit;
        BlockEntity blockEntity;
        HitResult hit;
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null || Minecraft.getInstance().screen != null) {
            return;
        }
        if (((KeyMapping)KEYMAPPING_UPDATE_CULLING.get()).consumeClick() && (hit = Minecraft.getInstance().hitResult) instanceof BlockHitResult && (blockEntity = level.getBlockEntity((blockHit = (BlockHitResult)hit).getBlockPos())) instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            try {
                be.updateCulling(true, true);
            }
            catch (Throwable throwable) {
                FramedBlocks.LOGGER.error("Encountered unexpected exception while updating culling of '{}'", (Object)be.getBlockState().getBlock(), (Object)throwable);
            }
            BlockPos pos = blockHit.getBlockPos();
            MutableComponent blockName = be.getBlockState().getBlock().getName();
            MutableComponent msg = Component.literal((String)"Culling updated for '").append((Component)blockName).append("' at ").append((Component)Component.literal((String)String.format("{x=%d, y=%d, z=%d}", pos.getX(), pos.getY(), pos.getZ())));
            Minecraft.getInstance().player.displayClientMessage((Component)msg, true);
        }
        if (((KeyMapping)KEYMAPPING_WIPE_CACHE.get()).consumeClick()) {
            FramedClientUtils.clearModelCaches();
            Minecraft.getInstance().player.displayClientMessage((Component)Component.literal((String)"Model cache cleared"), true);
        }
    }

    private KeyMappings() {
    }
}

