/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.textures.FluidSpriteCache;
import net.neoforged.neoforge.fluids.FluidStack;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.common.blockentity.special.FramedTankBlockEntity;

public class FramedTankRenderer
implements BlockEntityRenderer<FramedTankBlockEntity> {
    private static final float OFFSET = 0.01f;
    private static final float MIN_XZ = 0.01f;
    private static final float MAX_XZ = 0.99f;

    public FramedTankRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(FramedTankBlockEntity be, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        FluidStack fluid = be.getContents();
        if (fluid.isEmpty() || be.getLevel() == null) {
            return;
        }
        IClientFluidTypeExtensions fluidExt = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        FluidState fluidState = fluid.getFluid().defaultFluidState();
        int tint = fluidExt.getTintColor(fluidState, (BlockAndTintGetter)be.getLevel(), be.getBlockPos());
        ResourceLocation stillTex = fluidExt.getStillTexture(fluidState, (BlockAndTintGetter)be.getLevel(), be.getBlockPos());
        ResourceLocation flowTex = fluidExt.getFlowingTexture(fluidState, (BlockAndTintGetter)be.getLevel(), be.getBlockPos());
        RenderType renderType = ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState);
        FramedTankRenderer.renderContents(poseStack, buffer, renderType, light, fluid.getAmount(), stillTex, flowTex, tint);
    }

    public static void renderContents(PoseStack poseStack, MultiBufferSource buffer, RenderType renderType, int light, int fluidAmount, ResourceLocation stillTex, ResourceLocation flowTex, int tint) {
        float height = Mth.clamp((float)((float)fluidAmount / 16000.0f), (float)0.01f, (float)0.99f);
        boolean sameTex = stillTex.equals((Object)flowTex);
        RenderType bufferType = RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)true);
        VertexConsumer consumer = buffer.getBuffer(bufferType);
        PoseStack.Pose pose = poseStack.last();
        TextureAtlasSprite sprite = FluidSpriteCache.getSprite((ResourceLocation)flowTex);
        float minU = sprite.getU(0.01f);
        float maxU = sameTex ? sprite.getU(0.99f) : sprite.getU(0.49f);
        float minV = sameTex ? sprite.getV(1.0f - height) : sprite.getV(0.5f * (1.0f - height));
        float maxV = sameTex ? sprite.getV(0.99f) : sprite.getV(0.49f);
        consumer.addVertex(pose, 0.01f, height, 0.01f).setColor(tint).setUv(minU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, -1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, 0.01f, 0.01f, 0.01f).setColor(tint).setUv(minU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, -1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, 0.01f, 0.01f, 0.99f).setColor(tint).setUv(maxU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, -1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, 0.01f, height, 0.99f).setColor(tint).setUv(maxU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, -1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, 0.99f, height, 0.99f).setColor(tint).setUv(maxU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, 0.99f, 0.01f, 0.99f).setColor(tint).setUv(maxU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, 0.99f, 0.01f, 0.01f).setColor(tint).setUv(minU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, 0.99f, height, 0.01f).setColor(tint).setUv(minU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(pose, 0.99f, height, 0.01f).setColor(tint).setUv(maxU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 0.0f, -1.0f);
        consumer.addVertex(pose, 0.99f, 0.01f, 0.01f).setColor(tint).setUv(maxU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 0.0f, -1.0f);
        consumer.addVertex(pose, 0.01f, 0.01f, 0.01f).setColor(tint).setUv(minU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 0.0f, -1.0f);
        consumer.addVertex(pose, 0.01f, height, 0.01f).setColor(tint).setUv(minU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 0.0f, -1.0f);
        consumer.addVertex(pose, 0.01f, height, 0.99f).setColor(tint).setUv(minU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, 0.01f, 0.01f, 0.99f).setColor(tint).setUv(minU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, 0.99f, 0.01f, 0.99f).setColor(tint).setUv(maxU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(pose, 0.99f, height, 0.99f).setColor(tint).setUv(maxU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 0.0f, 1.0f);
        if (!sameTex) {
            sprite = FluidSpriteCache.getSprite((ResourceLocation)stillTex);
        }
        minU = sprite.getU(0.01f);
        maxU = sprite.getU(0.99f);
        minV = sprite.getV(0.01f);
        maxV = sprite.getV(0.99f);
        consumer.addVertex(pose, 0.99f, height, 0.99f).setColor(tint).setUv(maxU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, 0.99f, height, 0.01f).setColor(tint).setUv(maxU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, 0.01f, height, 0.01f).setColor(tint).setUv(minU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, 0.01f, height, 0.99f).setColor(tint).setUv(minU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, 0.01f, 0.01f, 0.99f).setColor(tint).setUv(minU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, -1.0f, 0.0f);
        consumer.addVertex(pose, 0.01f, 0.01f, 0.01f).setColor(tint).setUv(minU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, -1.0f, 0.0f);
        consumer.addVertex(pose, 0.99f, 0.01f, 0.01f).setColor(tint).setUv(maxU, minV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, -1.0f, 0.0f);
        consumer.addVertex(pose, 0.99f, 0.01f, 0.99f).setColor(tint).setUv(maxU, maxV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, 0.0f, -1.0f, 0.0f);
    }

    public boolean shouldRender(FramedTankBlockEntity be, Vec3 camera) {
        return (Boolean)be.getBlockState().getValue((Property)FramedProperties.SOLID) == false && super.shouldRender((BlockEntity)be, camera);
    }
}

