/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanelcorner;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelGeometry;

public class FramedLargeInnerCornerSlopePanelGeometry
extends Geometry {
    private final Direction dir;
    private final boolean top;
    private final boolean ySlope;

    public FramedLargeInnerCornerSlopePanelGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.top = (Boolean)ctx.state().getValue((Property)FramedProperties.TOP);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir == this.dir || quadDir == this.dir.getCounterClockWise()) {
            Direction cutDir = quadDir == this.dir ? this.dir.getClockWise() : this.dir.getOpposite();
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir.getOpposite(), this.top ? 0.5f : 0.0f, this.top ? 0.0f : 0.5f)).export(quadMap.get(quadDir));
            if (!this.ySlope) {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir, this.top ? 0.5f : 1.0f, this.top ? 1.0f : 0.5f)).apply(Modifiers.makeVerticalSlope(!this.top, FramedSlopePanelGeometry.SLOPE_ANGLE)).apply(Modifiers.offset(quadDir.getOpposite(), 0.5f)).export(quadMap.get(null));
            }
        } else if (this.ySlope && (!this.top && quadDir == Direction.UP || this.top && quadDir == Direction.DOWN)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f, 1.0f)).apply(Modifiers.makeVerticalSlope(this.dir.getCounterClockWise(), FramedSlopePanelGeometry.SLOPE_ANGLE_VERT)).export(quadMap.get(null));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getClockWise(), 1.0f, 0.5f)).apply(Modifiers.makeVerticalSlope(this.dir, FramedSlopePanelGeometry.SLOPE_ANGLE_VERT)).export(quadMap.get(null));
        } else if (!this.top && quadDir == Direction.DOWN || this.top && quadDir == Direction.UP) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.5f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir.getOpposite(), 0.5f)).apply(Modifiers.cutTopBottom(this.dir.getCounterClockWise(), 0.5f)).export(quadMap.get(quadDir));
        }
    }
}

