/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanel;

import com.google.common.base.Preconditions;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedSlopePanelGeometry
extends Geometry {
    public static final float SLOPE_ANGLE = (float)Math.toDegrees(Math.atan(0.5));
    public static final float SLOPE_ANGLE_VERT = (float)(90.0 - Math.toDegrees(Math.atan(0.5)));
    private final Direction facing;
    private final HorizontalRotation rotation;
    private final Direction orientation;
    private final Direction.Axis triangleAxis;
    private final boolean front;
    private final boolean ySlope;

    public FramedSlopePanelGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.rotation = (HorizontalRotation)((Object)ctx.state().getValue(PropertyHolder.ROTATION));
        this.orientation = this.rotation.withFacing(this.facing);
        this.triangleAxis = this.rotation.rotate(Rotation.CLOCKWISE_90).withFacing(this.facing).getAxis();
        this.front = (Boolean)ctx.state().getValue((Property)PropertyHolder.FRONT);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction face = quad.getDirection();
        boolean yAxis = Utils.isY(this.orientation);
        if (face == this.orientation.getOpposite()) {
            Direction cutDir;
            Direction direction = cutDir = this.front ? this.facing : this.facing.getOpposite();
            if (Utils.isY(this.orientation)) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(cutDir, 0.5f)).export(quadMap.get(face));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(cutDir, 0.5f)).export(quadMap.get(face));
            }
        } else if (!(this.rotation.isVertical() && this.ySlope || face != this.facing.getOpposite())) {
            QuadModifier.of(quad).apply(FramedSlopePanelGeometry.createSlope(this.facing, this.orientation)).applyIf(Modifiers.offset(this.facing, 0.5f), !this.front).export(quadMap.get(null));
        } else if (this.ySlope && FramedSlopePanelGeometry.isVerticalSlopeQuad(this.rotation, face)) {
            QuadModifier.of(quad).apply(FramedSlopePanelGeometry.createVerticalSlope(this.facing, this.orientation)).applyIf(Modifiers.offset(this.facing.getOpposite(), 0.5f), this.front).export(quadMap.get(null));
        } else if (face == this.facing) {
            if (this.front) {
                QuadModifier.of(quad).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
            }
        } else if (face.getAxis() == this.triangleAxis) {
            if (yAxis) {
                float top;
                boolean up;
                boolean bl = up = this.orientation == Direction.UP;
                float f = up ? (this.front ? 0.5f : 0.0f) : (top = this.front ? 1.0f : 0.5f);
                float bottom = up ? (this.front ? 1.0f : 0.5f) : (this.front ? 0.5f : 0.0f);
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing.getOpposite(), top, bottom)).applyIf(Modifiers.cutSideLeftRight(this.facing, 0.5f), this.front).export(quadMap.get(face));
            } else {
                float right;
                boolean rightRot;
                boolean bl = rightRot = this.rotation == HorizontalRotation.RIGHT;
                float f = rightRot ? (this.front ? 1.0f : 0.5f) : (right = this.front ? 0.5f : 0.0f);
                float left = rightRot ? (this.front ? 0.5f : 0.0f) : (this.front ? 1.0f : 0.5f);
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getOpposite(), right, left)).applyIf(Modifiers.cutTopBottom(this.facing, 0.5f), this.front).export(quadMap.get(face));
            }
        }
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return TranslatedItemModelInfo.HAND_Y_HALF_UP;
    }

    public static boolean isVerticalSlopeQuad(HorizontalRotation rotation, Direction face) {
        return switch (rotation) {
            case HorizontalRotation.DOWN -> {
                if (face == Direction.DOWN) {
                    yield true;
                }
                yield false;
            }
            case HorizontalRotation.UP -> {
                if (face == Direction.UP) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public static QuadModifier.Modifier createSlope(Direction facing, Direction orientation) {
        Preconditions.checkArgument((facing.getAxis() != orientation.getAxis() ? 1 : 0) != 0, (Object)"Directions must be perpendicular");
        if (Utils.isY(orientation)) {
            return Modifiers.makeVerticalSlope(orientation == Direction.UP, SLOPE_ANGLE);
        }
        return Modifiers.makeHorizontalSlope(orientation == facing.getCounterClockWise(), SLOPE_ANGLE);
    }

    public static QuadModifier.Modifier createVerticalSlope(Direction facing, Direction orientation) {
        Preconditions.checkArgument((facing.getAxis() != orientation.getAxis() ? 1 : 0) != 0, (Object)"Directions must be perpendicular");
        return Modifiers.makeVerticalSlope(facing.getOpposite(), SLOPE_ANGLE_VERT);
    }
}

