/*
 * Decompiled with CFR 0.152.
 */
package ironfurnaces.blocks.furnaces;

import ironfurnaces.blocks.furnaces.BlockIronFurnaceBase;
import ironfurnaces.init.Registration;
import ironfurnaces.tileentity.furnaces.BlockIronFurnaceTileBase;
import ironfurnaces.tileentity.furnaces.BlockNetheriteFurnaceTile;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockNetheriteFurnace
extends BlockIronFurnaceBase {
    public static final String NETHERITE_FURNACE = "netherite_furnace";

    public BlockNetheriteFurnace(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockNetheriteFurnace.createFurnaceTicker(level, type, Registration.NETHERITE_FURNACE_TILE.get());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            if (world.getBlockEntity(pos) == null) {
                return;
            }
            if (!(world.getBlockEntity(pos) instanceof BlockIronFurnaceTileBase)) {
                return;
            }
            BlockIronFurnaceTileBase tile = (BlockIronFurnaceTileBase)world.getBlockEntity(pos);
            if (tile.getItem(3).getItem() == Registration.SMOKING_AUGMENT.get()) {
                super.animateTick(state, world, pos, rand);
            } else if (tile.getItem(3).getItem() == Registration.BLASTING_AUGMENT.get()) {
                super.animateTick(state, world, pos, rand);
            } else {
                double d0 = (double)pos.getX() + 0.5;
                double d1 = pos.getY();
                double d2 = (double)pos.getZ() + 0.5;
                if (rand.nextDouble() < 0.1) {
                    world.playLocalSound(d0, d1, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
                Direction.Axis direction$axis = direction.getAxis();
                double d3 = 0.52;
                double d4 = rand.nextDouble() * 0.6 - 0.3;
                double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d4;
                double d6 = rand.nextDouble() * 6.0 / 16.0;
                double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d4;
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new BlockNetheriteFurnaceTile(p_153215_, p_153216_);
    }
}

