/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui;

import dev.isxander.yacl3.gui.TooltipButtonWidget;
import dev.isxander.yacl3.gui.utils.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;

public class TextScaledButtonWidget
extends TooltipButtonWidget {
    public float textScale;

    public TextScaledButtonWidget(Screen screen, int x, int y, int width, int height, float textScale, Component message, Component tooltip, Button.OnPress onPress) {
        super(screen, x, y, width, height, message, tooltip, onPress);
        this.textScale = textScale;
    }

    public TextScaledButtonWidget(Screen screen, int x, int y, int width, int height, float textScale, Component message, Button.OnPress onPress) {
        this(screen, x, y, width, height, textScale, message, null, onPress);
    }

    public void renderString(GuiGraphics graphics, Font textRenderer, int color) {
        Font font = Minecraft.getInstance().font;
        GuiUtils.pushPose(graphics);
        GuiUtils.translate2D(graphics, (float)this.getX() + (float)this.width / 2.0f - (float)font.width((FormattedText)this.getMessage()) * this.textScale / 2.0f, (float)this.getY() + ((float)this.height - 8.0f * this.textScale) / 2.0f / this.textScale);
        GuiUtils.scale2D(graphics, this.textScale, this.textScale);
        graphics.drawString(font, this.getMessage(), 0, 0, color | Mth.ceil((float)(this.alpha * 255.0f)) << 24, true);
        GuiUtils.popPose(graphics);
    }
}

