/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.mehvahdjukaar.dummmmmmy.client.TargetDummyModel;
import net.mehvahdjukaar.dummmmmmy.common.TargetDummyEntity;
import net.mehvahdjukaar.dummmmmmy.configs.ClientConfigs;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class LayerDummyCape
extends RenderLayer<TargetDummyEntity, TargetDummyModel<TargetDummyEntity>> {
    private final ItemRenderer itemRenderer;
    private final ModelPart flag;

    public LayerDummyCape(RenderLayerParent<TargetDummyEntity, TargetDummyModel<TargetDummyEntity>> renderer, EntityRendererProvider.Context context, ItemRenderer itemRenderer) {
        super(renderer);
        this.itemRenderer = itemRenderer;
        ModelPart modelPart = context.bakeLayer(ModelLayers.BANNER);
        this.flag = modelPart.getChild("flag");
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, TargetDummyEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack banner;
        Item item;
        if (!livingEntity.isInvisible() && (item = (banner = livingEntity.getOffhandItem()).getItem()) instanceof BannerItem) {
            BannerItem bi = (BannerItem)item;
            poseStack.pushPose();
            float scale = 0.5f;
            ModelPart head = ((TargetDummyModel)this.getParentModel()).getHead();
            poseStack.translate(head.x / 16.0f, head.y / 16.0f, head.z / 16.0f);
            poseStack.translate(0.0f, 0.0f, 0.125f);
            float bodyXRot = ((TargetDummyModel)this.getParentModel()).getBody().xRot;
            float capeRest = 0.08f;
            float phase = livingEntity.getShake(partialTicks);
            float unscaledSwingAmount = livingEntity.getAnimationPosition(partialTicks);
            float swingAmount = Math.min((float)((double)unscaledSwingAmount * ClientConfigs.ANIMATION_INTENSITY.get()), 40.0f);
            float capeSwingAngle = capeRest + (1.0f - capeRest - Mth.sin((float)phase)) * 0.02f * swingAmount;
            float naturalSwayPhase = ((float)Math.floorMod((long)livingEntity.tickCount, 100L) + partialTicks) / 100.0f;
            float naturalSway = 0.005f * Mth.cos((float)((float)Math.PI * 2 * naturalSwayPhase)) * (float)Math.PI;
            poseStack.mulPose(Axis.XP.rotation(bodyXRot + (float)Math.PI + Math.max(0.0f, capeSwingAngle += naturalSway)));
            poseStack.scale(-scale, -scale, 1.0f);
            ItemStack chestSlot = livingEntity.getItemBySlot(EquipmentSlot.CHEST);
            float dz = chestSlot.isEmpty() || chestSlot.getItem() instanceof ElytraItem ? 0.0625f : 0.0f;
            poseStack.translate(0.0f, 0.0f, dz);
            DyeColor dyeColor = bi.getColor();
            BannerPatternLayers patterns = (BannerPatternLayers)banner.get(DataComponents.BANNER_PATTERNS);
            BannerRenderer.renderPatterns((PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.flag, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)dyeColor, (BannerPatternLayers)patterns);
            poseStack.popPose();
        }
    }
}

