/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.google.common.io.Files;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.util.ChunkDataHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackUpHelper {
    private static final int MAX_COLONY_LOAD = 5000;
    private static final String REGION_FOLDER = "region";
    public static final String FILENAME_EXPORT = "colony%dExport.zip";
    private static final int MAX_BACKUPS = 20;
    public static long lastBackupTime = 0L;
    private static final long MAX_TIME_TO_NEXT_BACKUP = 300000L;

    private BackUpHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean backupColonyData(@NotNull HolderLookup.Provider provider) {
        if (System.currentTimeMillis() - lastBackupTime < 300000L) {
            return false;
        }
        lastBackupTime = System.currentTimeMillis();
        BackUpHelper.saveColonies(provider);
        try (FileOutputStream fos = new FileOutputStream(BackUpHelper.getBackupSaveLocation(new Date()));){
            int n;
            File[] i2;
            ArrayList<File> fileList;
            @NotNull File saveDir = new File(ServerLifecycleHooks.getCurrentServer().getWorldPath(LevelResource.ROOT).toFile(), "minecolonies");
            ZipOutputStream zos = new ZipOutputStream(fos);
            Iterator iterator = ServerLifecycleHooks.getCurrentServer().levelKeys().iterator();
            block9: while (true) {
                if (!iterator.hasNext()) {
                    BackUpHelper.addToZipFile(BackUpHelper.getSaveLocation().getName(), zos, saveDir);
                    zos.close();
                    File[] files = saveDir.listFiles();
                    if (files == null) {
                        boolean dimensionType = true;
                        return dimensionType;
                    }
                    fileList = new ArrayList<File>();
                    i2 = files;
                    n = i2.length;
                    break;
                }
                ResourceKey dimensionType = (ResourceKey)iterator.next();
                int i2 = 1;
                while (true) {
                    if (i2 > IColonyManager.getInstance().getTopColonyId() + 1) continue block9;
                    @NotNull File file = new File(saveDir, BackUpHelper.getFolderForDimension(dimensionType.location()) + String.format("colony%d.dat", i2));
                    @NotNull File fileDeleted = new File(saveDir, BackUpHelper.getFolderForDimension(dimensionType.location()) + String.format("colony%d.dat.deleted", i2));
                    if (file.exists()) {
                        if (IColonyManager.getInstance().getColonyByDimension(i2, (ResourceKey<Level>)dimensionType) == null) {
                            BackUpHelper.markColonyDeleted(i2, (ResourceKey<Level>)dimensionType);
                            BackUpHelper.addToZipFile(BackUpHelper.getFolderForDimension(dimensionType.location()) + String.format("colony%d.dat.deleted", i2), zos, saveDir);
                        } else {
                            BackUpHelper.addToZipFile(BackUpHelper.getFolderForDimension(dimensionType.location()) + String.format("colony%d.dat", i2), zos, saveDir);
                        }
                    } else if (fileDeleted.exists()) {
                        BackUpHelper.addToZipFile(BackUpHelper.getFolderForDimension(dimensionType.location()) + String.format("colony%d.dat.deleted", i2), zos, saveDir);
                    }
                    ++i2;
                }
                break;
            }
            for (int fileDeleted = 0; fileDeleted < n; ++fileDeleted) {
                File current = i2[fileDeleted];
                if (current.isDirectory() || !current.exists() || !current.getName().contains("colonies-")) continue;
                fileList.add(current);
            }
            if (fileList.size() <= 20) {
                boolean i2 = true;
                return i2;
            }
            fileList.sort(Comparator.comparingLong(File::lastModified));
            int deleteCount = fileList.size() - 20;
            Iterator iterator2 = fileList.iterator();
            while (iterator2.hasNext()) {
                File current = (File)iterator2.next();
                if (deleteCount <= 0) {
                    return true;
                }
                --deleteCount;
                current.delete();
            }
            return true;
        }
        catch (Exception e) {
            Log.getLogger().warn("Unable to backup colony data, please contact an administrator", (Throwable)e);
            return false;
        }
    }

    public static void loadManagerBackup(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        try {
            @NotNull File file = BackUpHelper.getSaveLocation();
            @Nullable CompoundTag data = BackUpHelper.loadNBTFromPath(file);
            if (data != null) {
                Log.getLogger().info("Loading Minecolonies colony manager Backup Data");
                IColonyManager.getInstance().read(provider, data);
                Log.getLogger().info("Backup Load Complete");
            }
        }
        catch (Exception e) {
            Log.getLogger().error("Error during restoring colony manager:", (Throwable)e);
        }
    }

    public static void loadMissingColonies() {
        @NotNull File saveDir = new File(ServerLifecycleHooks.getCurrentServer().getWorldPath(LevelResource.ROOT).toFile(), "minecolonies");
        for (ResourceKey dimensionType : ServerLifecycleHooks.getCurrentServer().levelKeys()) {
            int missingFilesInRow = 0;
            for (int i = 1; i <= 5000 && missingFilesInRow < 5; ++i) {
                @NotNull File file = new File(saveDir, BackUpHelper.getFolderForDimension(dimensionType.location()) + String.format("colony%d.dat", i));
                if (file.exists()) {
                    missingFilesInRow = 0;
                    if (IColonyManager.getInstance().getColonyByDimension(i, (ResourceKey<Level>)dimensionType) != null) continue;
                    BackUpHelper.loadColonyBackup(i, (ResourceKey<Level>)dimensionType, false, false);
                    continue;
                }
                ++missingFilesInRow;
            }
        }
    }

    @NotNull
    private static File getBackupSaveLocation(Date date) {
        @NotNull File saveDir = new File(ServerLifecycleHooks.getCurrentServer().getWorldPath(LevelResource.ROOT).toFile(), "minecolonies");
        return new File(saveDir, String.format("colonies-%s.zip", new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(date)));
    }

    private static void addToZipFile(String fileName, ZipOutputStream zos, File folder) {
        File file = new File(folder, fileName);
        BackUpHelper.addFileToZipWithPath(fileName, zos, file);
    }

    private static void addFileToZipWithPath(String zipPath, ZipOutputStream zos, File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            zos.putNextEntry(new ZipEntry(zipPath));
            Files.copy((File)file, (OutputStream)zos);
        }
        catch (Exception e) {
            Log.getLogger().warn("Error packing " + zipPath + " into the zip.", (Throwable)e);
        }
    }

    @NotNull
    public static File getSaveLocation() {
        @NotNull File saveDir = new File(ServerLifecycleHooks.getCurrentServer().getWorldPath(LevelResource.ROOT).toFile(), "minecolonies");
        return new File(saveDir, "colonies.dat");
    }

    public static void saveNBTToPath(@Nullable File file, @NotNull CompoundTag compound) {
        try {
            if (file != null) {
                file.getParentFile().mkdirs();
                NbtIo.write((CompoundTag)compound, (Path)file.toPath());
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when saving ColonyManager", (Throwable)exception);
        }
    }

    public static CompoundTag loadNBTFromPath(@Nullable File file) {
        try {
            if (file != null && file.exists()) {
                return NbtIo.read((Path)file.toPath());
            }
        }
        catch (IOException exception) {
            Log.getLogger().error("Exception when loading file from path in ColonyManager!", (Throwable)exception);
        }
        return null;
    }

    public static void saveColonies(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        @NotNull CompoundTag compound = new CompoundTag();
        IColonyManager.getInstance().write(provider, compound);
        @NotNull File file = BackUpHelper.getSaveLocation();
        BackUpHelper.saveNBTToPath(file, compound);
        @NotNull File saveDir = new File(ServerLifecycleHooks.getCurrentServer().getWorldPath(LevelResource.ROOT).toFile(), "minecolonies");
        for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
            CompoundTag colonyCompound = new CompoundTag();
            colony.write(colonyCompound, provider);
            BackUpHelper.saveNBTToPath(new File(saveDir, BackUpHelper.getFolderForDimension(colony.getDimension().location()) + String.format("colony%d.dat", colony.getID())), colonyCompound);
        }
    }

    public static void markColonyDeleted(int colonyID, ResourceKey<Level> dimensionID) {
        @NotNull File saveDir = new File(ServerLifecycleHooks.getCurrentServer().getWorldPath(LevelResource.ROOT).toFile(), "minecolonies");
        File toDelete = new File(saveDir, BackUpHelper.getFolderForDimension(dimensionID.location()) + String.format("colony%d.dat", colonyID));
        if (toDelete.exists()) {
            String fileName = BackUpHelper.getFolderForDimension(dimensionID.location()) + String.format("colony%d.dat.deleted", colonyID);
            File oldFile = new File(saveDir, fileName);
            if (oldFile.exists()) {
                oldFile.delete();
            }
            toDelete.renameTo(new File(saveDir, fileName));
        }
    }

    public static void loadAllBackups() {
        @NotNull File saveDir = new File(ServerLifecycleHooks.getCurrentServer().getWorldPath(LevelResource.ROOT).toFile(), "minecolonies");
        ServerLifecycleHooks.getCurrentServer().levelKeys().forEach(dimensionType -> {
            for (int i = 1; i <= IColonyManager.getInstance().getTopColonyId() + 1; ++i) {
                @NotNull File file = new File(saveDir, BackUpHelper.getFolderForDimension(dimensionType.location()) + String.format("colony%d.dat", i));
                if (!file.exists()) continue;
                BackUpHelper.loadColonyBackup(i, (ResourceKey<Level>)dimensionType, false, false);
            }
        });
    }

    private static String getFolderForDimension(ResourceLocation location) {
        return location.getNamespace() + File.separator + location.getPath() + File.separator;
    }

    public static void loadColonyBackup(int colonyId, ResourceKey<Level> dimension, boolean loadDeleted, boolean claimChunks) {
        IColony colony;
        @NotNull File saveDir = new File(ServerLifecycleHooks.getCurrentServer().getWorldPath(LevelResource.ROOT).toFile(), "minecolonies");
        @NotNull File backupFile = new File(saveDir, BackUpHelper.getFolderForDimension(dimension.location()) + String.format("colony%d.dat", colonyId));
        CompoundTag compound = BackUpHelper.loadNBTFromPath(backupFile);
        if (compound == null) {
            if (loadDeleted) {
                compound = BackUpHelper.loadNBTFromPath(new File(saveDir, String.format(BackUpHelper.getFolderForDimension(dimension.location()) + String.format("colony%d.dat.deleted", colonyId), new Object[0])));
            }
            if (compound == null) {
                Log.getLogger().warn("Can't find NBT of colony: " + colonyId + " at location: " + String.valueOf(backupFile));
                return;
            }
        }
        if ((colony = IColonyManager.getInstance().getColonyByDimension(colonyId, dimension)) != null) {
            colony.read(compound, (HolderLookup.Provider)colony.getWorld().registryAccess());
        } else {
            LevelChunk chunk;
            Log.getLogger().warn("Colony:" + colonyId + " is missing, loading backup!");
            ServerLevel colonyWorld = ServerLifecycleHooks.getCurrentServer().getLevel(dimension);
            Colony loadedColony = Colony.loadColony(compound, colonyWorld, (HolderLookup.Provider)colonyWorld.registryAccess());
            if (loadedColony == null || colonyWorld == null) {
                Log.getLogger().warn("Colony:" + colonyId + " loadBackup failed!");
                return;
            }
            loadedColony.setDimensionId(dimension);
            IColonyManager.getInstance().addColonyDirect(loadedColony, colonyWorld);
            if (claimChunks && ColonyUtils.getOwningColony((ChunkAccess)(chunk = (LevelChunk)colonyWorld.getChunk(loadedColony.getCenter()))) != colonyId) {
                BackUpHelper.reclaimChunks(loadedColony);
            }
        }
        Log.getLogger().warn("Successfully restored colony:" + colonyId);
    }

    public static void reclaimChunks(Colony colony) {
        ChunkDataHelper.claimColonyChunks(colony.getWorld(), true, colony, colony.getCenter());
        for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
            ChunkDataHelper.claimBuildingChunks(colony, true, building.getPosition(), building.getClaimRadius(building.getBuildingLevel()), building.getCorners());
        }
    }

    public static String exportColony(IColony colony) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        File topworldDir = server.getWorldPath(LevelResource.ROOT).toFile();
        File minecraftDir = new File(topworldDir.getAbsolutePath().replace(topworldDir.getPath(), ""));
        String worldname = topworldDir.getParent().replace("." + File.separator, "");
        String minecoloniesZipDir = worldname + File.separator + "minecolonies";
        File saveDir = new File(topworldDir, "minecolonies");
        try (FileOutputStream fos = new FileOutputStream(new File(saveDir, String.format(FILENAME_EXPORT, colony.getID())));){
            File latestlog;
            File config;
            File levelDat;
            File colonyManager;
            ZipOutputStream zos = new ZipOutputStream(fos);
            File regionDir = new File(DimensionType.getStorageFolder(colony.getDimension(), (Path)server.getWorldPath(LevelResource.ROOT)).toFile(), REGION_FOLDER);
            int maxX = Integer.MIN_VALUE;
            int minX = Integer.MAX_VALUE;
            int maxZ = Integer.MIN_VALUE;
            int minZ = Integer.MAX_VALUE;
            for (BlockPos buildingPos : colony.getBuildingManager().getBuildings().keySet()) {
                if (buildingPos.getX() > maxX) {
                    maxX = buildingPos.getX();
                }
                if (buildingPos.getX() < minX) {
                    minX = buildingPos.getX();
                }
                if (buildingPos.getZ() > maxZ) {
                    maxZ = buildingPos.getZ();
                }
                if (buildingPos.getZ() >= minZ) continue;
                minZ = buildingPos.getZ();
            }
            maxX >>= 9;
            minX >>= 9;
            maxZ >>= 9;
            minZ >>= 9;
            for (File currentRegion : regionDir.listFiles()) {
                String[] split;
                if (currentRegion == null || !currentRegion.getName().contains(".mca") || (split = currentRegion.getName().split("\\.")).length != 4) continue;
                int regionX = Integer.parseInt(split[1]);
                int regionZ = Integer.parseInt(split[2]);
                if (regionX > maxX || regionX < minX || regionZ > maxZ || regionZ < minZ) continue;
                BackUpHelper.addFileToZipWithPath(regionDir.getPath().replace("." + File.separator, "") + File.separator + currentRegion.getName(), zos, currentRegion);
            }
            File file = new File(saveDir, BackUpHelper.getFolderForDimension(colony.getDimension().location()) + String.format("colony%d.dat", colony.getID()));
            File fileDeleted = new File(saveDir, BackUpHelper.getFolderForDimension(colony.getDimension().location()) + String.format("colony%d.dat.deleted", colony.getID()));
            if (file.exists()) {
                BackUpHelper.addFileToZipWithPath(minecoloniesZipDir + File.separator + BackUpHelper.getFolderForDimension(colony.getDimension().location()) + String.format("colony%d.dat", colony.getID()), zos, file);
            }
            if (fileDeleted.exists()) {
                BackUpHelper.addFileToZipWithPath(minecoloniesZipDir + File.separator + BackUpHelper.getFolderForDimension(colony.getDimension().location()) + String.format("colony%d.dat.deleted", colony.getID()), zos, file);
            }
            if ((colonyManager = BackUpHelper.getSaveLocation()).exists()) {
                BackUpHelper.addFileToZipWithPath(minecoloniesZipDir + File.separator + colonyManager.getName(), zos, colonyManager);
            }
            if ((levelDat = new File(topworldDir, "level.dat")).exists()) {
                BackUpHelper.addFileToZipWithPath(worldname + File.separator + levelDat.getName(), zos, levelDat);
            }
            if ((config = new File(topworldDir, "serverconfig" + File.separator + "minecolonies-server.toml")).exists()) {
                BackUpHelper.addFileToZipWithPath(worldname + File.separator + "serverconfig" + File.separator + "minecolonies-server.toml", zos, config);
            }
            File modFolder = new File(minecraftDir, "mods");
            HashSet<String> mods = new HashSet<String>();
            if (modFolder.exists() && modFolder.isDirectory()) {
                for (File mod : modFolder.listFiles()) {
                    if (!mod.exists()) continue;
                    mods.add(mod.getName());
                }
            }
            if (!mods.isEmpty()) {
                zos.putNextEntry(new ZipEntry(worldname + File.separator + "mods.txt"));
                for (String mod : mods) {
                    zos.write(mod.concat("\n").getBytes());
                }
            }
            if ((latestlog = new File(minecraftDir, "logs" + File.separator + "latest.log")).exists()) {
                BackUpHelper.addFileToZipWithPath(worldname + File.separator + latestlog.getName(), zos, latestlog);
            }
            zos.close();
        }
        catch (Exception e) {
            Log.getLogger().warn("Unable to to create colony export", (Throwable)e);
            return "Unable to to create colony export";
        }
        return new File(saveDir, String.format(FILENAME_EXPORT, colony.getID())).getAbsolutePath();
    }
}

