/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.recipes;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.apiimp.initializer.ModIngredientTypeInitializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FoodIngredient(@NotNull Optional<Integer> minHealing, @NotNull Optional<Integer> maxHealing, @NotNull Optional<Float> minSaturation, @NotNull Optional<Float> maxSaturation) implements ICustomIngredient
{
    public static final MapCodec<FoodIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.optionalFieldOf("min-healing").forGetter(FoodIngredient::minHealing), (App)Codec.INT.optionalFieldOf("max-healing").forGetter(FoodIngredient::maxHealing), (App)Codec.FLOAT.optionalFieldOf("min-saturation").forGetter(FoodIngredient::minSaturation), (App)Codec.FLOAT.optionalFieldOf("max-saturation").forGetter(FoodIngredient::maxSaturation)).apply((Applicative)builder, FoodIngredient::new));

    public static Builder builder() {
        return new Builder();
    }

    private boolean matchesFood(@NotNull ItemStack stack) {
        @NotNull FoodProperties food = Objects.requireNonNull(stack.getItem().getFoodProperties(stack, null));
        return this.minHealing.map(healing -> food.nutrition() >= healing).orElse(true) != false && this.maxHealing.map(healing -> food.nutrition() < healing).orElse(true) != false && this.minSaturation.map(saturation -> food.saturation() >= saturation.floatValue()).orElse(true) != false && this.maxSaturation.map(saturation -> food.saturation() < saturation.floatValue()).orElse(true) != false;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return ItemStackUtils.IS_ANY_FOOD.test(stack) && this.matchesFood(stack);
    }

    @NotNull
    public Stream<ItemStack> getItems() {
        return BuiltInRegistries.ITEM.stream().map(ItemStack::new).filter(this::test);
    }

    public boolean isSimple() {
        return true;
    }

    @NotNull
    public IngredientType<?> getType() {
        return (IngredientType)ModIngredientTypeInitializer.FOOD_INGREDIENT_TYPE.get();
    }

    public static class Builder {
        private Optional<Integer> minHealing = Optional.empty();
        private Optional<Integer> maxHealing = Optional.empty();
        private Optional<Float> minSaturation = Optional.empty();
        private Optional<Float> maxSaturation = Optional.empty();

        private Builder() {
        }

        public Builder minHealing(int healing) {
            this.minHealing = Optional.of(healing);
            return this;
        }

        public Builder maxHealing(int healing) {
            this.maxHealing = Optional.of(healing);
            return this;
        }

        public Builder minSaturation(float saturation) {
            this.minSaturation = Optional.of(Float.valueOf(saturation));
            return this;
        }

        public Builder maxSaturation(float saturation) {
            this.maxSaturation = Optional.of(Float.valueOf(saturation));
            return this;
        }

        public Ingredient build() {
            return new FoodIngredient(this.minHealing, this.maxHealing, this.minSaturation, this.maxSaturation).toVanilla();
        }
    }
}

