/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.recipes;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewingCraftingType
extends CraftingType {
    public BrewingCraftingType() {
        super(ModCraftingTypes.BREWING_ID);
    }

    @Override
    @NotNull
    public List<IGenericRecipe> findRecipes(@NotNull RecipeManager recipeManager, @Nullable Level world) {
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        ICompatibilityManager compatibilityManager = MinecoloniesAPIProxy.getInstance().getColonyManager().getCompatibilityManager();
        List<ItemStack> containers = compatibilityManager.getListOfAllItems().stream().filter(arg_0 -> ((PotionBrewing)world.potionBrewing()).isInput(arg_0)).toList();
        List<ItemStack> ingredients = compatibilityManager.getListOfAllItems().stream().filter(arg_0 -> ((PotionBrewing)world.potionBrewing()).isIngredient(arg_0)).toList();
        for (ItemStack container : containers) {
            for (ItemStack ingredient : ingredients) {
                ItemStack output = world.potionBrewing().mix(ingredient, container);
                if (output.isEmpty() || output == container) continue;
                recipes.add(GenericRecipe.builder().withOutput(output.copyWithCount(3)).withInputs(List.of(List.of(ingredient), List.of(container.copyWithCount(3)))).withIntermediate(Blocks.BREWING_STAND).build());
            }
        }
        return recipes;
    }
}

