/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class WeatheredCopperPlacementHandler
implements IPlacementHandler {
    @Nullable
    private static BlockState getExpectedBlockState(Level world, BlockPos pos, BlockState blockState, boolean complete) {
        BlockState inWorldState = world.getBlockState(pos);
        if (complete) {
            return blockState;
        }
        Block block = inWorldState.getBlock();
        if (!(block instanceof WeatheringCopper)) {
            return blockState;
        }
        WeatheringCopper inWorldCopper = (WeatheringCopper)block;
        if (!(blockState.getBlock() instanceof WeatheringCopper) || !Objects.equals(WeatheringCopper.getFirst((Block)inWorldState.getBlock()), WeatheringCopper.getFirst((Block)blockState.getBlock()))) {
            return blockState;
        }
        Block currentBlock = blockState.getBlock();
        while (currentBlock != null && !((WeatheringCopper.WeatherState)((WeatheringCopper)currentBlock).getAge()).equals((Object)inWorldCopper.getAge())) {
            currentBlock = WeatheringCopper.getNext((Block)currentBlock).orElse(null);
        }
        if (currentBlock == null) {
            return blockState;
        }
        return null;
    }

    public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
        return blockState.getBlock() instanceof WeatheringCopper;
    }

    public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
        BlockState expectedBlockState = WeatheredCopperPlacementHandler.getExpectedBlockState(world, pos, blockState, complete);
        if (expectedBlockState == null) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (!world.setBlock(pos, expectedBlockState, 3)) {
            return IPlacementHandler.ActionProcessingResult.DENY;
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        BlockState expectedBlockState = WeatheredCopperPlacementHandler.getExpectedBlockState(world, pos, blockState, complete);
        return expectedBlockState != null ? List.of(BlockUtils.getItemStackFromBlockState((BlockState)expectedBlockState)) : List.of();
    }
}

