/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.structurize.api.ItemStackUtils;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.core.blocks.BlockMinecoloniesGrave;
import com.minecolonies.core.tileentities.TileEntityGrave;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GravePlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.getBlock() instanceof BlockMinecoloniesGrave;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
        BlockEntity entity;
        if (world.getBlockState(pos).getBlock() == ModBlocks.blockGrave) {
            return IPlacementHandler.ActionProcessingResult.SUCCESS;
        }
        world.setBlock(pos, blockState, 3);
        if (tileEntityData != null) {
            PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (RotationMirror)settings);
        }
        if ((entity = world.getBlockEntity(pos)) instanceof TileEntityGrave) {
            ((TileEntityGrave)entity).updateBlockState();
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        itemList.add(BlockUtils.getItemStackFromBlockState((BlockState)blockState));
        for (ItemStack stack : PlacementHandlers.getItemsFromTileEntity((CompoundTag)tileEntityData, (BlockState)blockState, (Level)world)) {
            if (ItemStackUtils.isEmpty((ItemStack)stack)) continue;
            itemList.add(stack);
        }
        return itemList;
    }
}

