/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.domumornamentum.block.AbstractBlockDoor;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyDoorBlock;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.placement.handlers.placement.PlacementHandlers;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoDoorBlockPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState) {
        return blockState.getBlock() instanceof IMateriallyTexturedBlock && blockState.getBlock() instanceof AbstractBlockDoor;
    }

    public IPlacementHandler.ActionProcessingResult handle(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
        if (((DoubleBlockHalf)blockState.getValue((Property)DoorBlock.HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
            if (world.getBlockState(pos).equals(blockState)) {
                world.removeBlock(pos, false);
                world.removeBlock(pos.above(), false);
                world.setBlock(pos, blockState, 3);
                world.setBlock(pos.above(), (BlockState)blockState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
                if (tileEntityData != null) {
                    try {
                        PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (RotationMirror)settings);
                        PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos.above(), (RotationMirror)settings);
                    }
                    catch (Exception ex) {
                        Log.getLogger().warn("Unable to place TileEntity");
                    }
                }
                return IPlacementHandler.ActionProcessingResult.PASS;
            }
            world.setBlock(pos, (BlockState)blockState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER), 3);
            world.setBlock(pos.above(), (BlockState)blockState.setValue((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
            if (tileEntityData != null) {
                try {
                    PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos, (RotationMirror)settings);
                    PlacementHandlers.handleTileEntityPlacement((CompoundTag)tileEntityData, (Level)world, (BlockPos)pos.above(), (RotationMirror)settings);
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Unable to place TileEntity");
                }
            }
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    public List<ItemStack> getRequiredItems(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        if (tileEntityData != null && ((DoubleBlockHalf)blockState.getValue((Property)DoorBlock.HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
            BlockPos blockpos = new BlockPos(tileEntityData.getInt("x"), tileEntityData.getInt("y"), tileEntityData.getInt("z"));
            BlockEntity tileEntity = BlockEntity.loadStatic((BlockPos)blockpos, (BlockState)blockState, (CompoundTag)tileEntityData, (HolderLookup.Provider)world.registryAccess());
            if (tileEntity == null) {
                return Collections.emptyList();
            }
            Object property = blockState.getBlock() instanceof com.ldtteam.domumornamentum.block.vanilla.DoorBlock ? com.ldtteam.domumornamentum.block.vanilla.DoorBlock.TYPE : (blockState.getBlock() instanceof FancyDoorBlock ? FancyDoorBlock.TYPE : null);
            itemList.add(property == null ? BlockUtils.getMaterializedItemStack((BlockEntity)tileEntity, (HolderLookup.Provider)world.registryAccess(), (Property[])new Property[0]) : BlockUtils.getMaterializedItemStack((BlockEntity)tileEntity, (HolderLookup.Provider)world.registryAccess(), (Property[])new Property[]{property}));
        }
        return itemList;
    }
}

