/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.university;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingUniversity;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class TryResearchMessage
extends AbstractBuildingServerMessage<BuildingUniversity> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"try_research_message", TryResearchMessage::new);
    private final ResourceLocation researchId;
    private final ResourceLocation branch;
    private final boolean reset;

    public TryResearchMessage(IBuildingView building, @NotNull ResourceLocation researchId, ResourceLocation branch, boolean reset) {
        super(TYPE, building);
        this.researchId = researchId;
        this.branch = branch;
        this.reset = reset;
    }

    protected TryResearchMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.researchId = buf.readResourceLocation();
        this.branch = buf.readResourceLocation();
        this.reset = buf.readBoolean();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeResourceLocation(this.researchId);
        buf.writeResourceLocation(this.branch);
        buf.writeBoolean(this.reset);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, BuildingUniversity building) {
        IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(this.branch, this.researchId);
        if (this.reset) {
            if (colony.getResearchManager().getResearchTree().getResearch(this.branch, this.researchId) != null) {
                colony.getResearchManager().getResearchTree().attemptResetResearch((Player)player, colony, colony.getResearchManager().getResearchTree().getResearch(this.branch, this.researchId));
            }
        } else if (research.canResearch(building.getBuildingLevel() == building.getMaxBuildingLevel() ? Integer.MAX_VALUE : building.getBuildingLevel(), colony.getResearchManager().getResearchTree()) || player.isCreative()) {
            colony.getResearchManager().getResearchTree().attemptBeginResearch((Player)player, colony, research);
        }
    }
}

