/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.fields;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildingextensions.registry.BuildingExtensionDataManager;
import com.minecolonies.core.colony.buildings.modules.BuildingExtensionsModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import io.netty.buffer.Unpooled;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class AssignFieldMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"assign_field", AssignFieldMessage::new);
    private final int moduleID;
    private final RegistryFriendlyByteBuf fieldData;
    private final boolean assign;

    public AssignFieldMessage(IBuildingView building, IBuildingExtension field, boolean assign, int moduleID) {
        super(TYPE, building);
        this.assign = assign;
        this.fieldData = BuildingExtensionDataManager.extensionToBuffer(field, building.getColony().getWorld().registryAccess());
        this.moduleID = moduleID;
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        this.fieldData.resetReaderIndex();
        buf.writeBoolean(this.assign);
        buf.writeInt(this.moduleID);
        buf.writeByteArray(this.fieldData.array());
    }

    protected AssignFieldMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.assign = buf.readBoolean();
        this.moduleID = buf.readInt();
        this.fieldData = new RegistryFriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buf.readByteArray()), buf.registryAccess());
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        IBuildingExtension parsedField = BuildingExtensionDataManager.bufferToExtension(this.fieldData);
        colony.getBuildingManager().getMatchingBuildingExtension(otherField -> otherField.equals(parsedField)).ifPresent(field -> {
            IBuildingModule patt0$temp = building.getModule(this.moduleID);
            if (patt0$temp instanceof BuildingExtensionsModule) {
                BuildingExtensionsModule fieldsModule = (BuildingExtensionsModule)patt0$temp;
                if (this.assign) {
                    fieldsModule.assignExtension((IBuildingExtension)field);
                } else {
                    fieldsModule.freeExtension((IBuildingExtension)field);
                }
            }
        });
    }
}

