/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.inventory.container.ContainerCraftingBrewingstand;
import com.minecolonies.api.inventory.container.ContainerCraftingFurnace;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class OpenCraftingGUIMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"open_crafting_gui", OpenCraftingGUIMessage::new);
    private final int id;

    public OpenCraftingGUIMessage(@NotNull AbstractBuildingView building, int id) {
        super(TYPE, building);
        this.id = id;
    }

    protected OpenCraftingGUIMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.id = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.id);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, final IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (iBuildingModule instanceof AbstractCraftingBuildingModule) {
            final AbstractCraftingBuildingModule module = (AbstractCraftingBuildingModule)iBuildingModule;
            if (module.canLearn((CraftingType)ModCraftingTypes.SMELTING.get())) {
                player.openMenu(new MenuProvider(){

                    @NotNull
                    public Component getDisplayName() {
                        return Component.literal((String)"Furnace Crafting GUI");
                    }

                    @NotNull
                    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
                        return new ContainerCraftingFurnace(id, inv, building.getID(), module.getProducer().getRuntimeID());
                    }
                }, buffer -> new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf((ByteBuf)buffer.writeBlockPos(building.getID()).writeInt(module.getProducer().getRuntimeID())), buffer.registryAccess()));
            } else if (module.canLearn((CraftingType)ModCraftingTypes.BREWING.get())) {
                player.openMenu(new MenuProvider(){

                    @NotNull
                    public Component getDisplayName() {
                        return Component.literal((String)"Brewing Crafting GUI");
                    }

                    @NotNull
                    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
                        return new ContainerCraftingBrewingstand(id, inv, building.getID(), module.getProducer().getRuntimeID());
                    }
                }, buffer -> new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf((ByteBuf)buffer.writeBlockPos(building.getID()).writeInt(module.getProducer().getRuntimeID())), buffer.registryAccess()));
            } else {
                player.openMenu(new MenuProvider(){

                    @NotNull
                    public Component getDisplayName() {
                        return Component.literal((String)"Crafting GUI");
                    }

                    @NotNull
                    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inv, @NotNull Player player) {
                        return new ContainerCrafting(id, inv, module.canLearn((CraftingType)ModCraftingTypes.LARGE_CRAFTING.get()), building.getID(), module.getProducer().getRuntimeID());
                    }
                }, buffer -> new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf((ByteBuf)buffer.writeBoolean(module.canLearn((CraftingType)ModCraftingTypes.LARGE_CRAFTING.get()))), buffer.registryAccess()).writeBlockPos(building.getID()).writeInt(module.getProducer().getRuntimeID()));
            }
        }
    }
}

