/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class UpdateRequestStateMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"update_request_state", UpdateRequestStateMessage::new);
    private final IToken<?> token;
    private final ItemStack itemStack;
    private final RequestState state;

    public UpdateRequestStateMessage(IColony colony, IToken<?> requestId, RequestState state, ItemStack itemStack) {
        super(TYPE, colony);
        this.token = requestId;
        this.state = state;
        this.itemStack = itemStack;
    }

    protected UpdateRequestStateMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.token = (IToken)StandardFactoryController.getInstance().deserialize(buf);
        this.state = RequestState.values()[buf.readInt()];
        this.itemStack = this.state == RequestState.OVERRULED ? Utils.deserializeCodecMess(buf) : ItemStack.EMPTY;
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        StandardFactoryController.getInstance().serialize(buf, this.token);
        buf.writeInt(this.state.ordinal());
        if (this.state == RequestState.OVERRULED) {
            Utils.serializeCodecMess(buf, this.itemStack);
        }
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        if (this.state == RequestState.OVERRULED) {
            colony.getRequestManager().overruleRequest(this.token, this.itemStack);
            return;
        }
        colony.getRequestManager().updateRequestState(this.token, this.state);
    }
}

