/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class InteractionClose
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"interaction_close", InteractionClose::new);
    private final int citizenId;
    private final Component key;

    public InteractionClose(int colonyId, int citizenId, ResourceKey<Level> dimension, @NotNull Component key) {
        super(TYPE, dimension, colonyId);
        this.citizenId = citizenId;
        this.key = key;
    }

    protected InteractionClose(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.citizenId = buf.readInt();
        this.key = (Component)Utils.deserializeCodecMess(ComponentSerialization.STREAM_CODEC, buf);
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.citizenId);
        Utils.serializeCodecMess(ComponentSerialization.STREAM_CODEC, buf, this.key);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(this.citizenId);
        if (citizenData == null) {
            citizenData = colony.getVisitorManager().getVisitor(this.citizenId);
        }
        if (citizenData != null && player != null) {
            citizenData.onInteractionClosed(this.key, player);
        }
    }
}

