/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ReactivateBuildingMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"reactivate_building", ReactivateBuildingMessage::new);
    private final BlockPos pos;

    public ReactivateBuildingMessage(BlockPos pos) {
        super(TYPE);
        this.pos = pos;
    }

    protected ReactivateBuildingMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.pos = buf.readBlockPos();
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player) {
        BlockEntity tileEntity;
        AbstractBuilding building;
        Level world = player.getCommandSenderWorld();
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, this.pos);
        if (colony != null && colony.getPermissions().hasPermission((Player)player, Action.MANAGE_HUTS) && (building = (AbstractBuilding)colony.getBuildingManager().getBuilding(this.pos)) == null && (tileEntity = world.getBlockEntity(this.pos)) instanceof TileEntityColonyBuilding) {
            TileEntityColonyBuilding hut = (TileEntityColonyBuilding)tileEntity;
            if (!colony.getBuildingManager().canPlaceAt(tileEntity.getBlockState().getBlock(), this.pos, (Player)player)) {
                return;
            }
            hut.reactivate();
            colony.getBuildingManager().addNewBuilding(hut, world);
        }
    }
}

