/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.eventbus.events.colony.ColonyCreatedModEvent;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.network.messages.client.colony.OpenBuildingUIMessage;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class CreateColonyMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"create_colony", CreateColonyMessage::new);
    private final BlockPos townHall;
    private final boolean claim;
    private final String colonyName;
    private final String packName;
    private final String pathName;

    public CreateColonyMessage(BlockPos townHall, boolean claim, String colonyName, String packName, String pathName) {
        super(TYPE);
        this.townHall = townHall;
        this.claim = claim;
        this.colonyName = colonyName;
        this.packName = packName;
        this.pathName = pathName;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.townHall);
        buf.writeBoolean(this.claim);
        buf.writeUtf(this.colonyName);
        buf.writeUtf(this.packName);
        buf.writeUtf(this.pathName);
    }

    protected CreateColonyMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.townHall = buf.readBlockPos();
        this.claim = buf.readBoolean();
        this.colonyName = buf.readUtf(Short.MAX_VALUE);
        this.packName = buf.readUtf(Short.MAX_VALUE);
        this.pathName = buf.readUtf(Short.MAX_VALUE);
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer sender) {
        boolean reactivate;
        ServerLevel world = sender.serverLevel();
        IColony colony = IColonyManager.getInstance().getClosestColony((Level)world, this.townHall);
        String pack = this.packName;
        BlockEntity tileEntity = world.getBlockEntity(this.townHall);
        if (!(tileEntity instanceof TileEntityColonyBuilding)) {
            MessageUtils.format("com.minecolonies.coremod.gui.colony.create.notileentity", new Object[0]).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(new Player[]{sender});
            return;
        }
        TileEntityColonyBuilding hut = (TileEntityColonyBuilding)tileEntity;
        if (hut.getStructurePack() != null && this.claim) {
            pack = hut.getStructurePack().getName();
        }
        if (reactivate = ((List)hut.getPositionedTags().getOrDefault(BlockPos.ZERO, new ArrayList())).contains("deactivated")) {
            hut.reactivate();
            if (hut.getStructurePack() != null) {
                pack = hut.getStructurePack().getName();
            }
        }
        hut.setStructurePack(StructurePacks.getStructurePack((String)pack));
        hut.setBlueprintPath(this.pathName);
        double spawnDistance = Math.sqrt(BlockPosUtil.getDistanceSquared2D(this.townHall, world.getSharedSpawnPos()));
        if (spawnDistance < (double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).minDistanceFromWorldSpawn.get()).intValue()) {
            if (!world.isClientSide) {
                MessageUtils.format("com.minecolonies.core.founding.tooclosetospawn", (double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).minDistanceFromWorldSpawn.get()).intValue() - spawnDistance).sendTo(new Player[]{sender});
            }
            return;
        }
        if (spawnDistance > (double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxDistanceFromWorldSpawn.get()).intValue()) {
            if (!world.isClientSide) {
                MessageUtils.format("com.minecolonies.core.founding.toofarfromspawn", spawnDistance - (double)((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).maxDistanceFromWorldSpawn.get()).intValue()).sendTo(new Player[]{sender});
            }
            return;
        }
        if (colony != null && !IColonyManager.getInstance().isFarEnoughFromColonies((Level)world, this.townHall)) {
            MessageUtils.format("com.minecolonies.coremod.gui.colony.denied.tooclose", colony.getName()).sendTo(new Player[]{sender});
            return;
        }
        IColony ownedColony = IColonyManager.getInstance().getIColonyByOwner((Level)world, (Player)sender);
        if (ownedColony == null) {
            IColony createdColony = IColonyManager.getInstance().createColony(world, this.townHall, (Player)sender, this.colonyName, pack);
            IBuilding building = createdColony.getBuildingManager().addNewBuilding((TileEntityColonyBuilding)tileEntity, (Level)world);
            if (reactivate) {
                MessageUtils.format("com.minecolonies.coremod.progress.colony_reactivated", this.colonyName).withPriority(MessageUtils.MessagePriority.IMPORTANT).sendTo(new Player[]{sender});
            } else {
                MessageUtils.format("com.minecolonies.coremod.progress.colony_founded", new Object[0]).withPriority(MessageUtils.MessagePriority.IMPORTANT).sendTo(new Player[]{sender});
            }
            IMinecoloniesAPI.getInstance().getEventBus().post(new ColonyCreatedModEvent(createdColony));
            new OpenBuildingUIMessage(building).sendToPlayer(sender);
            return;
        }
        ownedColony.getPackageManager().sendColonyViewPackets();
        ownedColony.getPackageManager().sendPermissionsPackets();
        MessageUtils.format("com.minecolonies.coremod.gui.colony.create.failed", new Object[0]).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(new Player[]{sender});
    }
}

