/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.colony.Colony;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewRemoveWorkOrderMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"colony_view_remove_workorder", ColonyViewRemoveWorkOrderMessage::new);
    private final int colonyId;
    private final int workOrderId;

    public ColonyViewRemoveWorkOrderMessage(@NotNull Colony colony, int workOrderId) {
        super(TYPE);
        this.colonyId = colony.getID();
        this.workOrderId = workOrderId;
    }

    protected ColonyViewRemoveWorkOrderMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.colonyId = buf.readInt();
        this.workOrderId = buf.readInt();
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.workOrderId);
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        IColonyManager.getInstance().handleColonyViewRemoveWorkOrderMessage(this.colonyId, this.workOrderId, (ResourceKey<Level>)player.level().dimension());
    }
}

