/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.colony.Colony;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewRemoveBuildingMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"colony_view_remove_building", ColonyViewRemoveBuildingMessage::new);
    private final int colonyId;
    private final BlockPos buildingId;

    public ColonyViewRemoveBuildingMessage(@NotNull Colony colony, BlockPos building) {
        super(TYPE);
        this.colonyId = colony.getID();
        this.buildingId = building;
    }

    protected ColonyViewRemoveBuildingMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.colonyId = buf.readInt();
        this.buildingId = buf.readBlockPos();
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeBlockPos(this.buildingId);
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        IColonyManager.getInstance().handleColonyViewRemoveBuildingMessage(this.colonyId, this.buildingId, (ResourceKey<Level>)player.level().dimension());
    }
}

