/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.colony.Colony;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewCitizenViewMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"colony_view_citizen_view", ColonyViewCitizenViewMessage::new);
    private final int colonyId;
    private final int citizenId;
    private final RegistryFriendlyByteBuf citizenBuffer;
    private final ResourceKey<Level> dimension;

    public ColonyViewCitizenViewMessage(@NotNull Colony colony, @NotNull ICitizenData citizen) {
        super(TYPE);
        this.colonyId = colony.getID();
        this.citizenId = citizen.getId();
        this.citizenBuffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), colony.getWorld().registryAccess());
        this.dimension = citizen.getColony().getDimension();
        citizen.serializeViewNetworkData(this.citizenBuffer);
    }

    protected ColonyViewCitizenViewMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.colonyId = buf.readInt();
        this.citizenId = buf.readInt();
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.citizenBuffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buf.readByteArray())), buf.registryAccess());
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        this.citizenBuffer.resetReaderIndex();
        buf.writeInt(this.colonyId);
        buf.writeInt(this.citizenId);
        buf.writeUtf(this.dimension.location().toString());
        buf.writeByteArray(this.citizenBuffer.array());
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        IColonyManager.getInstance().handleColonyViewCitizensMessage(this.colonyId, this.citizenId, this.citizenBuffer, this.dimension);
    }
}

