/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.util.Utils;
import java.util.Random;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ItemParticleEffectMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"item_particle_effect", ItemParticleEffectMessage::new);
    private static final Random RAND = new Random();
    private final ItemStack stack;
    private final double rotationPitch;
    private final double rotationYaw;
    private final double eyeHeight;
    private final double posX;
    private final double posY;
    private final double posZ;

    public ItemParticleEffectMessage(ItemStack stack, double posX, double posY, double posZ, double rotationPitch, double rotationYaw, double eyeHeight) {
        super(TYPE);
        this.stack = stack;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.rotationPitch = rotationPitch;
        this.rotationYaw = rotationYaw;
        this.eyeHeight = eyeHeight;
    }

    protected ItemParticleEffectMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.stack = (ItemStack)Utils.deserializeCodecMess(ItemStack.STREAM_CODEC, buf);
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.rotationPitch = buf.readDouble();
        this.rotationYaw = buf.readDouble();
        this.eyeHeight = buf.readDouble();
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        Utils.serializeCodecMess(ItemStack.STREAM_CODEC, buf, this.stack);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.rotationPitch);
        buf.writeDouble(this.rotationYaw);
        buf.writeDouble(this.eyeHeight);
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        if (this.stack.getUseAnimation() == UseAnim.EAT) {
            for (int i = 0; i < 5; ++i) {
                Vec3 randomPos = new Vec3((RAND.nextDouble() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                randomPos = randomPos.xRot((float)(-this.rotationPitch * 0.01745329238474369));
                randomPos = randomPos.yRot((float)(-this.rotationYaw * 0.01745329238474369));
                double d0 = -RAND.nextDouble() * 0.6 - 0.3;
                Vec3 randomOffset = new Vec3((RAND.nextDouble() - 0.5) * 0.3, d0, 0.6);
                randomOffset = randomOffset.xRot((float)(-this.rotationPitch * 0.01745329238474369));
                randomOffset = randomOffset.yRot((float)(-this.rotationYaw * 0.01745329238474369));
                randomOffset = randomOffset.add(this.posX, this.posY + this.eyeHeight, this.posZ);
                player.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.stack), randomOffset.x, randomOffset.y, randomOffset.z, randomPos.x, randomPos.y + 0.05, randomPos.z);
            }
        }
    }
}

