/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.core.items.ItemFood;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSugaryBread
extends ItemFood {
    private static FoodProperties sweetBread = new FoodProperties.Builder().nutrition(6).saturationModifier(0.7f).effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600), 1.0f).build();

    public ItemSugaryBread(Item.Properties properties) {
        super(new Item.Properties().food(sweetBread), 1);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        if (!worldIn.isClientSide) {
            entityLiving.removeEffect(MobEffects.POISON);
        }
        return super.finishUsingItem(stack, worldIn, entityLiving);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext ctx, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        MutableComponent guiHint = Component.translatableEscape((String)"com.minecolonies.coremod.item.sugary.bread.gui", (Object[])new Object[0]);
        guiHint.setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
        tooltip.add((Component)guiHint);
        super.appendHoverText(stack, ctx, tooltip, flagIn);
    }
}

