/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;
import org.jetbrains.annotations.NotNull;

public class ItemLargeBottle
extends Item {
    public ItemLargeBottle(@NotNull Item.Properties builder) {
        super(builder);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        if (this != ModItems.large_empty_bottle) {
            return super.interactLivingEntity(stack, player, entity, hand);
        }
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return super.interactLivingEntity(stack, player, entity, hand);
        }
        if (entity instanceof Cow && !entity.isBaby()) {
            player.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
            if (!InventoryUtils.addItemStackToItemHandler((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), ModItems.large_milk_bottle.getDefaultInstance())) {
                player.drop(ModItems.large_milk_bottle.getDefaultInstance(), false);
            }
            stack.shrink(1);
            player.getCooldowns().addCooldown((Item)this, 200);
            return InteractionResult.SUCCESS;
        }
        if (entity instanceof Goat) {
            Goat goat = (Goat)entity;
            if (!entity.isBaby()) {
                player.playSound(goat.isScreamingGoat() ? SoundEvents.GOAT_SCREAMING_MILK : SoundEvents.GOAT_MILK, 1.0f, 1.0f);
                if (!InventoryUtils.addItemStackToItemHandler((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), ModItems.large_milk_bottle.getDefaultInstance())) {
                    player.drop(ModItems.large_milk_bottle.getDefaultInstance(), false);
                }
                stack.shrink(1);
                player.getCooldowns().addCooldown((Item)this, 200);
                return InteractionResult.SUCCESS;
            }
        }
        return super.interactLivingEntity(stack, player, entity, hand);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this != ModItems.large_empty_bottle) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        BlockHitResult blockhitresult = ItemLargeBottle.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (blockhitresult.getType() != HitResult.Type.MISS && blockhitresult.getType() == HitResult.Type.BLOCK) {
            BlockPos blockpos = blockhitresult.getBlockPos();
            if (!level.mayInteract(player, blockpos)) {
                return InteractionResultHolder.pass((Object)itemstack);
            }
            if (level.getFluidState(blockpos).is(FluidTags.WATER)) {
                level.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                if (!InventoryUtils.addItemStackToItemHandler((IItemHandler)new PlayerMainInvWrapper(player.getInventory()), ModItems.large_water_bottle.getDefaultInstance())) {
                    player.drop(ModItems.large_water_bottle.getDefaultInstance(), false);
                }
                itemstack.shrink(1);
                player.getCooldowns().addCooldown((Item)this, 20);
                return InteractionResultHolder.success((Object)itemstack);
            }
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }
}

