/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.map.WindowColonyMap;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ItemColonyMap
extends AbstractItemMinecolonies {
    public ItemColonyMap(Item.Properties properties) {
        super("colonymap", properties.stacksTo(1));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack colonymap = ctx.getPlayer().getItemInHand(ctx.getHand());
        BlockEntity entity = ctx.getLevel().getBlockEntity(ctx.getClickedPos());
        if (entity instanceof TileEntityColonyBuilding) {
            TileEntityColonyBuilding buildingEntity = (TileEntityColonyBuilding)entity;
            buildingEntity.writeColonyToItemStack(colonymap);
            if (!ctx.getLevel().isClientSide) {
                MessageUtils.format("com.minecolonies.core.item.colonymap.registered", buildingEntity.getColony().getName()).sendTo(ctx.getPlayer());
            }
        } else if (ctx.getLevel().isClientSide) {
            ItemColonyMap.openWindow(colonymap, ctx.getLevel(), ctx.getPlayer());
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack colonymap = playerIn.getItemInHand(hand);
        if (!worldIn.isClientSide) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)colonymap);
        }
        ItemColonyMap.openWindow(colonymap, worldIn, playerIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)colonymap);
    }

    private static void openWindow(ItemStack stack, Level world, Player player) {
        IColonyView colonyView = ColonyId.readColonyViewFromItemStack(stack);
        if (colonyView != null && colonyView.getTownHall() != null) {
            new WindowColonyMap(false, colonyView.getTownHall()).open();
        } else {
            player.displayClientMessage((Component)Component.translatableEscape((String)"com.minecolonies.core.item.colonymap.needcolony", (Object[])new Object[0]), true);
        }
    }
}

