/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults.workers;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.generation.CustomRecipeProvider;
import com.minecolonies.core.generation.defaults.workers.DefaultRecipeLootProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class DefaultBakerCraftingProvider
extends CustomRecipeProvider {
    private static final String BAKER = ModJobs.BAKER_ID.getPath();

    public DefaultBakerCraftingProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @NotNull
    public String getName() {
        return "DefaultBakerCraftingProvider";
    }

    @Override
    protected void registerRecipes(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer) {
        ItemStack waterBottle = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER);
        this.recipe(BAKER, "crafting", "water_bottle").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.GLASS_BOTTLE)))).result(waterBottle).minBuildingLevel(3).build(consumer);
        this.recipe(BAKER, "crafting", "bread_dough").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.WHEAT), 3))).result(new ItemStack((ItemLike)ModItems.breadDough)).maxBuildingLevel(2).showTooltip(true).build(consumer);
        this.recipe(BAKER, "crafting", "bread_dough3").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.WHEAT)), new ItemStorage(ModItems.large_water_bottle.getDefaultInstance()))).result(new ItemStack((ItemLike)ModItems.breadDough, 2)).minBuildingLevel(3).lootTable(DefaultRecipeLootProvider.LOOT_TABLE_LARGE_BOTTLE).showTooltip(true).build(consumer);
        this.recipe(BAKER, "smelting", "bread").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModItems.breadDough)))).result(new ItemStack((ItemLike)Items.BREAD)).intermediate(Blocks.FURNACE).build(consumer);
        this.recipe(BAKER, "crafting", "sugary_bread").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum, 8)), new ItemStorage(new ItemStack((ItemLike)Items.HONEY_BOTTLE)))).result(new ItemStack((ItemLike)ModItems.sugaryBread, 4)).lootTable(DefaultRecipeLootProvider.LOOT_TABLE_GLASS_BOTTLE).minBuildingLevel(3).showTooltip(true).build(consumer);
        this.recipe(BAKER, "crafting", "milky_bread").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum, 8)), new ItemStorage(new ItemStack((ItemLike)ModItems.large_milk_bottle)))).result(new ItemStack((ItemLike)ModItems.milkyBread, 4)).lootTable(DefaultRecipeLootProvider.LOOT_TABLE_LARGE_BOTTLE).minBuildingLevel(4).showTooltip(true).build(consumer);
        this.recipe(BAKER, "crafting", "smilky_bread").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum, 8)), new ItemStorage(new ItemStack((ItemLike)ModItems.large_soy_milk_bottle)))).result(new ItemStack((ItemLike)ModItems.milkyBread, 4)).lootTable(DefaultRecipeLootProvider.LOOT_TABLE_LARGE_BOTTLE).minBuildingLevel(4).showTooltip(true).build(consumer);
        this.recipe(BAKER, "crafting", "golden_bread").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum, 8)), new ItemStorage(new ItemStack((ItemLike)Items.GOLD_INGOT)))).result(new ItemStack((ItemLike)ModItems.goldenBread, 4)).minBuildingLevel(5).showTooltip(true).build(consumer);
        this.recipe(BAKER, "crafting", "chorus_bread").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum, 8)), new ItemStorage(new ItemStack((ItemLike)Items.CHORUS_FRUIT)))).result(new ItemStack((ItemLike)ModItems.chorusBread, 4)).minResearchId(ResearchConstants.THE_END).showTooltip(true).build(consumer);
        this.recipe(BAKER, "crafting", "cookie_dough").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.WHEAT, 2)), new ItemStorage(new ItemStack((ItemLike)Items.COCOA_BEANS, 2)))).result(new ItemStack((ItemLike)ModItems.cookieDough, 8)).minBuildingLevel(2).showTooltip(true).build(consumer);
        this.recipe(BAKER, "smelting", "cookie").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModItems.cookieDough)))).result(new ItemStack((ItemLike)Items.COOKIE)).minBuildingLevel(2).intermediate(Blocks.FURNACE).build(consumer);
        this.recipe(BAKER, "crafting", "raw_pumpkin_pie").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.PUMPKIN)), new ItemStorage(new ItemStack((ItemLike)Items.SUGAR)), new ItemStorage(new ItemStack((ItemLike)Items.EGG)))).result(new ItemStack((ItemLike)ModItems.rawPumpkinPie)).minBuildingLevel(3).showTooltip(true).build(consumer);
        this.recipe(BAKER, "smelting", "pumpkin_pie").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModItems.rawPumpkinPie)))).result(new ItemStack((ItemLike)Items.PUMPKIN_PIE)).minBuildingLevel(3).intermediate(Blocks.FURNACE).build(consumer);
        this.recipe(BAKER, "crafting", "cake_batter").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.WHEAT, 3)), new ItemStorage(new ItemStack((ItemLike)ModItems.large_milk_bottle, 3)), new ItemStorage(new ItemStack((ItemLike)Items.SUGAR, 2)), new ItemStorage(new ItemStack((ItemLike)Items.EGG)))).result(new ItemStack((ItemLike)ModItems.cakeBatter)).lootTable(DefaultRecipeLootProvider.LOOT_TABLE_LARGE_BOTTLE).minBuildingLevel(4).showTooltip(true).build(consumer);
        this.recipe(BAKER, "crafting", "scake_batter").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.WHEAT, 3)), new ItemStorage(new ItemStack((ItemLike)ModItems.large_soy_milk_bottle, 3)), new ItemStorage(new ItemStack((ItemLike)Items.SUGAR, 2)), new ItemStorage(new ItemStack((ItemLike)Items.EGG)))).result(new ItemStack((ItemLike)ModItems.cakeBatter)).lootTable(DefaultRecipeLootProvider.LOOT_TABLE_LARGE_BOTTLE).minBuildingLevel(4).showTooltip(true).build(consumer);
        this.recipe(BAKER, "smelting", "cake").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModItems.cakeBatter)))).result(new ItemStack((ItemLike)Items.CAKE)).minBuildingLevel(4).intermediate(Blocks.FURNACE).build(consumer);
        this.recipe(BAKER, "crafting", "lembas_scone").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum)), new ItemStorage(new ItemStack((ItemLike)ModItems.butter)), new ItemStorage(new ItemStack((ItemLike)Items.HONEY_BOTTLE)))).result(new ItemStack((ItemLike)ModItems.lembas_scone)).lootTable(DefaultRecipeLootProvider.LOOT_TABLE_GLASS_BOTTLE).showTooltip(true).build(consumer);
        this.recipe(BAKER, "crafting", "manchet_dough").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum)), new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum)), new ItemStorage(new ItemStack((ItemLike)ModItems.butter)))).result(new ItemStack((ItemLike)ModItems.manchet_dough, 2)).showTooltip(true).build(consumer);
        this.recipe(BAKER, "crafting", "muffin_dough").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum)), new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum)), new ItemStorage(new ItemStack((ItemLike)ModItems.butter)), new ItemStorage(new ItemStack((ItemLike)Items.SUGAR)), new ItemStorage(new ItemStack((ItemLike)Items.SWEET_BERRIES)))).result(new ItemStack((ItemLike)ModItems.muffin_dough, 2)).showTooltip(true).build(consumer);
        this.recipe(BAKER, "crafting", "flatbread").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum)), new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum)), new ItemStorage(ModItems.large_water_bottle.getDefaultInstance()))).result(new ItemStack((ItemLike)ModItems.flatbread, 1)).lootTable(DefaultRecipeLootProvider.LOOT_TABLE_LARGE_BOTTLE).showTooltip(true).build(consumer);
        this.recipe(BAKER, "smelting", "muffin").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModItems.muffin_dough)))).result(new ItemStack((ItemLike)ModItems.muffin)).showTooltip(true).intermediate(Blocks.FURNACE).build(consumer);
        this.recipe(BAKER, "smelting", "manchet").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModItems.manchet_dough)))).result(new ItemStack((ItemLike)ModItems.manchet_bread)).showTooltip(true).intermediate(Blocks.FURNACE).build(consumer);
        this.recipe(BAKER, "crafting", "water_jug").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModItems.large_empty_bottle)))).result(ModItems.large_water_bottle.getDefaultInstance()).build(consumer);
        this.recipe(BAKER, "crafting", "mintchoco_cheesecake").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModItems.plain_cheesecake)), new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockMint)), new ItemStorage(new ItemStack((ItemLike)Items.COCOA_BEANS)), new ItemStorage(new ItemStack((ItemLike)Items.COCOA_BEANS)))).result(new ItemStack((ItemLike)ModItems.mintchoco_cheesecake, 1)).minBuildingLevel(4).build(consumer);
        this.recipe(BAKER, "crafting", "mushroom_pizza").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum)), new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum)), new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockDurum)), new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockTomato)), new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockTomato)), new ItemStorage(new ItemStack((ItemLike)ModBlocks.blockGarlic)), new ItemStorage(new ItemStack((ItemLike)ModItems.cheddar_cheese)), new ItemStorage(new ItemStack((ItemLike)Items.BROWN_MUSHROOM)), new ItemStorage(new ItemStack((ItemLike)Items.BROWN_MUSHROOM)))).result(new ItemStack((ItemLike)ModItems.mushroom_pizza, 1)).minBuildingLevel(4).build(consumer);
    }
}

