/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.ldtteam.structurize.items.ModItems;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.crafting.ZeroWasteRecipe;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.core.generation.CompostRecipeBuilder;
import com.minecolonies.core.recipes.FoodIngredient;
import com.minecolonies.core.recipes.PlantIngredient;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class DefaultRecipeProvider
extends RecipeProvider {
    public DefaultRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(@NotNull RecipeOutput consumer) {
        this.buildHutRecipes(consumer);
        this.buildOtherBlocks(consumer);
        this.buildOtherItems(consumer);
        this.buildFood(consumer);
        CompostRecipeBuilder.strength(2).input(FoodIngredient.builder().maxSaturation(0.5f).build()).input(Ingredient.of(ModTags.compostables_poor)).save(consumer, TagConstants.COMPOSTABLES_POOR);
        CompostRecipeBuilder.strength(4).input(FoodIngredient.builder().minSaturation(0.5f).maxSaturation(1.0f).build()).input(PlantIngredient.of()).input(Ingredient.of(ModTags.compostables)).save(consumer, TagConstants.COMPOSTABLES);
        CompostRecipeBuilder.strength(8).input(FoodIngredient.builder().minSaturation(1.0f).build()).input(Ingredient.of(ModTags.compostables_rich)).save(consumer, TagConstants.COMPOSTABLES_RICH);
    }

    private void buildHutRecipes(@NotNull RecipeOutput consumer) {
        DefaultRecipeProvider.registerHutRecipe3(consumer, ModBlocks.blockHutArchery, (ItemLike)Items.BOW);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutBaker, (ItemLike)Items.WHEAT);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutBarracks, (ItemLike)Items.IRON_BLOCK);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutBeekeeper, (ItemLike)Items.BEEHIVE);
        DefaultRecipeProvider.registerHutRecipe3(consumer, ModBlocks.blockHutBlacksmith, (ItemLike)Items.IRON_INGOT);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutBuilder, (TagKey<Item>)ItemTags.WOODEN_DOORS);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutChickenHerder, (ItemLike)Items.EGG);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutHome, (ItemLike)Items.TORCH);
        DefaultRecipeProvider.registerHutRecipe3(consumer, ModBlocks.blockHutCombatAcademy, (ItemLike)Items.IRON_SWORD);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutComposter, ModBlocks.blockBarrel);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutConcreteMixer, (ItemLike)Items.WHITE_CONCRETE_POWDER);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutCook, (ItemLike)Items.APPLE);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutCowboy, (ItemLike)Items.BEEF);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutDeliveryman, (ItemLike)Items.LEATHER_BOOTS);
        DefaultRecipeProvider.registerHutRecipe1x2(consumer, ModBlocks.blockHutDeliveryman, (ItemLike)Items.IRON_BOOTS, "iron");
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutDyer, (ItemLike)Items.RED_DYE);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutEnchanter, (ItemLike)Items.ENCHANTING_TABLE);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutFarmer, (ItemLike)Items.WOODEN_HOE);
        DefaultRecipeProvider.registerHutRecipe1x2(consumer, ModBlocks.blockHutFarmer, (ItemLike)Items.STONE_HOE, "stone");
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutFisherman, (ItemLike)Items.FISHING_ROD);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutFletcher, (ItemLike)Items.STRING);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutFlorist, (ItemLike)Items.POPPY);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutGlassblower, (ItemLike)Items.GLASS);
        DefaultRecipeProvider.registerHutRecipe1x2(consumer, ModBlocks.blockHutGuardTower, (ItemLike)Items.BOW, "");
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutHospital, (ItemLike)Items.CARROT);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutLibrary, (ItemLike)Items.BOOK);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutLumberjack, (ItemLike)Items.WOODEN_AXE);
        DefaultRecipeProvider.registerHutRecipe1x2(consumer, ModBlocks.blockHutLumberjack, (ItemLike)Items.STONE_AXE, "stone");
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutMechanic, (ItemLike)Items.REDSTONE_BLOCK);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutMiner, (ItemLike)Items.WOODEN_PICKAXE);
        DefaultRecipeProvider.registerHutRecipe1x2(consumer, ModBlocks.blockHutMiner, (ItemLike)Items.STONE_PICKAXE, "stone");
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutMysticalSite, (ItemLike)Items.DIAMOND);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutPlantation, (ItemLike)Items.CACTUS);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutRabbitHutch, (ItemLike)Items.RABBIT);
        DefaultRecipeProvider.registerHutRecipe3(consumer, ModBlocks.blockHutSawmill, (ItemLike)Items.WOODEN_AXE);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutShepherd, (ItemLike)Items.SHEARS);
        DefaultRecipeProvider.registerHutRecipe3(consumer, ModBlocks.blockHutSifter, (ItemLike)Items.STRING);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutSmeltery, (ItemLike)Items.IRON_INGOT);
        DefaultRecipeProvider.registerHutRecipe3(consumer, ModBlocks.blockHutStonemason, (ItemLike)Items.STONE_BRICKS);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutSwineHerder, (ItemLike)Items.PORKCHOP);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutTavern, (ItemLike)Items.BARREL);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutTownHall, (ItemLike)ModItems.buildTool.get());
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutWareHouse, (TagKey<Item>)Tags.Items.CHESTS);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutNetherWorker, (ItemLike)Items.OBSIDIAN);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutAlchemist, (ItemLike)Items.BREWING_STAND);
        DefaultRecipeProvider.registerHutRecipe1(consumer, ModBlocks.blockHutKitchen, (ItemLike)Items.SMOKER);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockHutCrusher).pattern("XTX").pattern("CBC").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('C'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('B'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.IRON_INGOT})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockHutGraveyard).pattern("XTX").pattern("XBX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)Items.STONE).define(Character.valueOf('B'), (ItemLike)Items.BONE).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.BONE})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockHutSchool).pattern("XTX").pattern("XBX").pattern("XBX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('B'), (ItemLike)Items.FEATHER).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.FEATHER})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockHutUniversity).pattern("XTX").pattern("XBX").pattern("XBX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.BOOK})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockHutStoneSmeltery).pattern("XTX").pattern("AFA").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('A'), (ItemLike)Items.STONE_BRICKS).define(Character.valueOf('F'), (ItemLike)Items.FURNACE).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.STONE_BRICKS})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockScarecrow).pattern(" H ").pattern("SLS").pattern(" S ").define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('H'), Ingredient.of((ItemLike[])new ItemLike[]{Items.HAY_BLOCK, Items.PUMPKIN})).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), ModBlocks.blockHutFarmer})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockPlantationField).pattern(" T ").pattern("SIS").pattern("PPP").define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), ModBlocks.blockHutPlantation})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockSimpleQuarry).pattern("XTX").pattern("XDX").pattern("XBX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('D'), (ItemLike)Items.IRON_PICKAXE).define(Character.valueOf('B'), (ItemLike)Items.BARREL).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), ModBlocks.blockHutMiner})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockMediumQuarry).pattern("XTX").pattern("XDX").pattern("XBX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('D'), (ItemLike)Items.DIAMOND_PICKAXE).define(Character.valueOf('B'), (ItemLike)Items.BARREL).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), ModBlocks.blockHutMiner})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockHutGateHouse).pattern("XTX").pattern("CXB").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('B'), (ItemLike)Items.BOW).define(Character.valueOf('C'), (ItemLike)Items.IRON_SWORD).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.IRON_SWORD, Items.BOW})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockColonySign, (int)6).pattern("XXX").pattern("XXX").pattern(" T ").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf((ItemLike)ModItems.buildTool.get())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)com.minecolonies.api.items.ModItems.assistantHammer_Gold).pattern("GGG").pattern("GBG").pattern(" S ").define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('B'), (ItemLike)ModItems.buildTool.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), ModBlocks.blockHutBuilder})).save(consumer);
    }

    private static Criterion<?> hasAllOf(ItemLike ... items) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])items);
    }

    private static Criterion<?> hasAllOf(ItemPredicate ... predicates) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])predicates);
    }

    private static ResourceLocation append(@NotNull ResourceLocation base, @NotNull String text1, @NotNull String text2) {
        if (text2.isEmpty()) {
            return base;
        }
        return new ResourceLocation("minecolonies", base.getPath() + text1 + text2);
    }

    private static ResourceLocation append(@NotNull ItemLike item, @NotNull String text) {
        return DefaultRecipeProvider.append(BuiltInRegistries.ITEM.getKey((Object)item.asItem()), "", text);
    }

    private static void registerHutRecipe1(@NotNull RecipeOutput consumer, @NotNull ItemLike output, @NotNull ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern("XTX").pattern("XBX").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('B'), input).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf((ItemLike)ModItems.buildTool.get(), input)).save(consumer);
    }

    private static void registerHutRecipe1(@NotNull RecipeOutput consumer, @NotNull ItemLike output, @NotNull TagKey<Item> input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern("XTX").pattern("XBX").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('B'), input).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ModItems.buildTool.get()}).build(), ItemPredicate.Builder.item().of(input).build())).save(consumer);
    }

    private static void registerHutRecipe1x2(@NotNull RecipeOutput consumer, @NotNull ItemLike output, @NotNull ItemLike input, @NotNull String name) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)2).pattern("XTX").pattern("XBX").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('B'), input).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf((ItemLike)ModItems.buildTool.get(), input)).save(consumer, DefaultRecipeProvider.append(output, name));
    }

    private static void registerHutRecipe3(@NotNull RecipeOutput consumer, @NotNull ItemLike output, @NotNull ItemLike input) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).pattern("XTX").pattern("BBB").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('B'), input).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf((ItemLike)ModItems.buildTool.get(), input)).save(consumer);
    }

    private void buildOtherBlocks(@NotNull RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockBarrel).pattern("WTW").pattern("WGW").pattern("WSW").define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('S'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('G'), (ItemLike)Items.DIRT).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), Items.IRON_INGOT})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockCompostedDirt).pattern("XXX").pattern("XPX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)Items.DIRT).define(Character.valueOf('P'), (ItemLike)com.minecolonies.api.items.ModItems.compost).unlockedBy("has_compost", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.compost)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockConstructionTape).pattern("SWS").pattern("S S").pattern("S S").define(Character.valueOf('W'), ItemTags.WOOL).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_wool", DefaultRecipeProvider.has((TagKey)ItemTags.WOOL)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockPostBox).pattern("XSX").pattern("III").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('I'), Tags.Items.CHESTS).define(Character.valueOf('S'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ModItems.buildTool.get()}).build(), ItemPredicate.Builder.item().of(Tags.Items.CHESTS).build())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockStash).pattern("XSX").pattern("IXI").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('I'), Tags.Items.CHESTS).define(Character.valueOf('S'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ModItems.buildTool.get()}).build(), ItemPredicate.Builder.item().of(Tags.Items.CHESTS).build())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockRack).pattern("XXX").pattern("ISI").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('I'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('S'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_build_tool", DefaultRecipeProvider.has((ItemLike)((ItemLike)ModItems.buildTool.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModBlocks.blockWayPoint, (int)16).pattern("XXX").pattern("XBX").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('B'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_build_tool", DefaultRecipeProvider.has((ItemLike)((ItemLike)ModItems.buildTool.get()))).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LARGE_FERN).requires((ItemLike)Items.FERN).requires((ItemLike)Items.FERN).unlockedBy("has_fern", DefaultRecipeProvider.has((ItemLike)Items.FERN)).save(consumer, new ResourceLocation("minecolonies", "doublefern"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.TALL_GRASS).requires((ItemLike)Items.SHORT_GRASS).requires((ItemLike)Items.SHORT_GRASS).unlockedBy("has_grass", DefaultRecipeProvider.has((ItemLike)Items.SHORT_GRASS)).save(consumer, new ResourceLocation("minecolonies", "doublegrass"));
    }

    private void buildFood(@NotNull RecipeOutput consumer) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.breadDough}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD, (float)0.35f, (int)300).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.breadDough)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_bread"), "_", ""));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.cakeBatter}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.CAKE, (float)0.35f, (int)300).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.cakeBatter)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_cake"), "_", ""));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.cookieDough}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.COOKIE, (float)0.0475f, (int)37).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.cookieDough)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_cookies"), "_", ""));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.rawPumpkinPie}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.PUMPKIN_PIE, (float)0.35f, (int)300).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.rawPumpkinPie)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_pumpkin_pie"), "_", ""));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.manchet_dough}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.manchet_bread, (float)0.35f, (int)300).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.manchet_dough)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_manchet_bread"), "_", ""));
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.muffin_dough}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.muffin, (float)0.35f, (int)300).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.muffin_dough)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_muffin"), "_", ""));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.breadDough}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD, (float)0.35f, (int)100).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.breadDough)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_bread"), "_", "smoking"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.cakeBatter}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.CAKE, (float)0.35f, (int)100).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.cakeBatter)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_cake"), "_", "smoking"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.cookieDough}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.COOKIE, (float)0.0475f, (int)12).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.cookieDough)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_cookies"), "_", "smoking"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.rawPumpkinPie}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.PUMPKIN_PIE, (float)0.35f, (int)100).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.rawPumpkinPie)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_pumpkin_pie"), "_", "smoking"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.manchet_dough}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.manchet_bread, (float)0.35f, (int)100).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.manchet_dough)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_manchet_bread"), "_", "smoking"));
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.muffin_dough}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.muffin, (float)0.35f, (int)100).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.muffin_dough)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_muffin"), "_", "smoking"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.breadDough}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.BREAD, (float)0.35f, (int)600).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.breadDough)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_bread"), "_", "campfire_cooking"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.cakeBatter}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.CAKE, (float)0.35f, (int)600).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.cakeBatter)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_cake"), "_", "campfire_cooking"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.cookieDough}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.COOKIE, (float)0.0475f, (int)75).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.cookieDough)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_cookies"), "_", "campfire_cooking"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.rawPumpkinPie}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)Items.PUMPKIN_PIE, (float)0.35f, (int)600).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.rawPumpkinPie)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_pumpkin_pie"), "_", "campfire_cooking"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.manchet_dough}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.manchet_bread, (float)0.35f, (int)600).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.manchet_dough)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_manchet_bread"), "_", "campfire_cooking"));
        SimpleCookingRecipeBuilder.campfireCooking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.muffin_dough}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.muffin, (float)0.35f, (int)600).unlockedBy("has_dough", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.muffin_dough)).save(consumer, DefaultRecipeProvider.append(new ResourceLocation("minecolonies", "baked_muffin"), "_", "campfire_cooking"));
    }

    private void buildOtherItems(@NotNull RecipeOutput consumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)com.minecolonies.api.items.ModItems.flagBanner).pattern(" W ").pattern(" W ").pattern(" B ").define(Character.valueOf('W'), ItemTags.WOOL).define(Character.valueOf('B'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)ModItems.buildTool.get()}).build(), ItemPredicate.Builder.item().of(ItemTags.WOOL).build())).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)com.minecolonies.api.items.ModItems.bannerRallyGuards).pattern("AAA").pattern("BXB").pattern("CCC").define(Character.valueOf('A'), (ItemLike)Items.IRON_SWORD).define(Character.valueOf('B'), ModBlocks.blockHutGuardTower).define(Character.valueOf('X'), (ItemLike)Items.YELLOW_BANNER).define(Character.valueOf('C'), (ItemLike)Items.BOW).unlockedBy("has_items", DefaultRecipeProvider.hasAllOf(new ItemLike[]{(ItemLike)ModItems.buildTool.get(), ModBlocks.blockHutGuardTower})).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CHAINMAIL_HELMET).pattern("NCN").pattern("N N").define(Character.valueOf('C'), (ItemLike)Items.CHAIN).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).unlockedBy("has_iron", DefaultRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(consumer, new ResourceLocation("minecolonies", "chainmailhelmet"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CHAINMAIL_CHESTPLATE).pattern("C C").pattern("NNN").pattern("NNN").define(Character.valueOf('C'), (ItemLike)Items.CHAIN).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).unlockedBy("has_iron", DefaultRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(consumer, new ResourceLocation("minecolonies", "chainmailchestplate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CHAINMAIL_LEGGINGS).pattern("CNC").pattern("N N").pattern("N N").define(Character.valueOf('C'), (ItemLike)Items.CHAIN).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).unlockedBy("has_iron", DefaultRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(consumer, new ResourceLocation("minecolonies", "chainmailleggings"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CHAINMAIL_BOOTS).pattern("C C").pattern("N N").define(Character.valueOf('C'), (ItemLike)Items.CHAIN).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).unlockedBy("has_iron", DefaultRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(consumer, new ResourceLocation("minecolonies", "chainmailboots"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)com.minecolonies.api.items.ModItems.clipboard).pattern("XTX").pattern("XPX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)Items.STICK).define(Character.valueOf('P'), (ItemLike)Items.LEATHER).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_build_tool", DefaultRecipeProvider.has((ItemLike)((ItemLike)ModItems.buildTool.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)com.minecolonies.api.items.ModItems.questLog).pattern("XTX").pattern("LPL").pattern("XPX").define(Character.valueOf('P'), (ItemLike)Items.PAPER).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('X'), (ItemLike)Items.STICK).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_build_tool", DefaultRecipeProvider.has((ItemLike)((ItemLike)ModItems.buildTool.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)com.minecolonies.api.items.ModItems.resourceScroll).pattern("XTX").pattern("XPX").pattern("XPX").define(Character.valueOf('X'), (ItemLike)Items.STICK).define(Character.valueOf('P'), (ItemLike)Items.LEATHER).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_build_tool", DefaultRecipeProvider.has((ItemLike)((ItemLike)ModItems.buildTool.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)com.minecolonies.api.items.ModItems.buildGoggles).pattern("NIN").pattern("GTG").pattern("L L").define(Character.valueOf('N'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('G'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('L'), (ItemLike)Items.LEATHER).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_build_tool", DefaultRecipeProvider.has((ItemLike)((ItemLike)ModItems.buildTool.get()))).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.shapeTool.get())).pattern("  X").pattern(" S ").pattern("S  ").define(Character.valueOf('X'), (ItemLike)Items.EMERALD).define(Character.valueOf('S'), (ItemLike)Items.STICK).unlockedBy("has_stick", DefaultRecipeProvider.has((ItemLike)Items.STICK)).save(consumer, new ResourceLocation("minecolonies", "shapetool"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)com.minecolonies.api.items.ModItems.supplyCamp).pattern("   ").pattern("C C").pattern("CCC").define(Character.valueOf('C'), Tags.Items.CHESTS).unlockedBy("has_chest", DefaultRecipeProvider.has((TagKey)Tags.Items.CHESTS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)com.minecolonies.api.items.ModItems.supplyChest).pattern("   ").pattern("B B").pattern("BBB").define(Character.valueOf('B'), ItemTags.BOATS).unlockedBy("has_boat", DefaultRecipeProvider.has((TagKey)ItemTags.BOATS)).save(consumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)com.minecolonies.api.items.ModItems.large_empty_bottle, (int)4).pattern("PSP").pattern("P P").pattern("PGP").define(Character.valueOf('P'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('G'), (ItemLike)Items.GLASS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).unlockedBy("has_glass", DefaultRecipeProvider.has((TagKey)Tags.Items.GLASS_BLOCKS)).save(consumer);
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.scimitar}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_NUGGET, (float)0.1f, (int)200).unlockedBy("has_scimitar", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.scimitar)).save(consumer, new ResourceLocation("minecolonies", "iron_nugget_from_iron_scimitar_smelting"));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{com.minecolonies.api.items.ModItems.scimitar}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_NUGGET, (float)0.1f, (int)100).unlockedBy("has_scimitar", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.scimitar)).save(consumer, new ResourceLocation("minecolonies", "iron_nugget_from_iron_scimitar_blasting"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)com.minecolonies.api.items.ModItems.colonyMap).pattern("XXX").pattern("XTX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)Items.MAP).define(Character.valueOf('T'), (ItemLike)ModItems.buildTool.get()).unlockedBy("has_build_tool", DefaultRecipeProvider.has((ItemLike)((ItemLike)ModItems.buildTool.get()))).save(consumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)com.minecolonies.api.items.ModItems.large_water_bottle).requires((ItemLike)com.minecolonies.api.items.ModItems.large_empty_bottle).requires(Tags.Items.BUCKETS_WATER).unlockedBy("has_bottle", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.large_empty_bottle)).save(consumer, new ResourceLocation("minecolonies", "large_water_bottle"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.butter, (int)3).pattern("MMM").pattern("MMM").define(Character.valueOf('M'), (ItemLike)com.minecolonies.api.items.ModItems.large_milk_bottle).unlockedBy("has_milk", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.large_milk_bottle)).save(consumer, new ResourceLocation("minecolonies", "butter"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.butter, (int)3).pattern("MMM").pattern("MMM").define(Character.valueOf('M'), (ItemLike)com.minecolonies.api.items.ModItems.large_soy_milk_bottle).unlockedBy("has_soy_milk", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.large_soy_milk_bottle)).save(consumer, new ResourceLocation("minecolonies", "soy_butter"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.cheddar_cheese, (int)2).pattern("MM").pattern("MM").define(Character.valueOf('M'), (ItemLike)com.minecolonies.api.items.ModItems.large_milk_bottle).unlockedBy("has_milk", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.large_milk_bottle)).save(consumer, new ResourceLocation("minecolonies", "cheddar_cheese"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.feta_cheese).pattern("MM").define(Character.valueOf('M'), (ItemLike)com.minecolonies.api.items.ModItems.large_milk_bottle).unlockedBy("has_milk", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.large_milk_bottle)).save(consumer, new ResourceLocation("minecolonies", "feta_cheese"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.creamcheese, (int)2).pattern(" M ").pattern("MMM").define(Character.valueOf('M'), (ItemLike)com.minecolonies.api.items.ModItems.large_milk_bottle).unlockedBy("has_milk", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.large_milk_bottle)).save(consumer, new ResourceLocation("minecolonies", "cream_cheese"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.creamcheese, (int)2).pattern(" M ").pattern("MMM").define(Character.valueOf('M'), (ItemLike)com.minecolonies.api.items.ModItems.large_soy_milk_bottle).unlockedBy("has_soy_milk", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.large_soy_milk_bottle)).save(consumer, new ResourceLocation("minecolonies", "soy_cream_cheese"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.tofu).requires((ItemLike)ModBlocks.blockSoyBean).unlockedBy("has_soy", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockSoyBean)).save(consumer, new ResourceLocation("minecolonies", "tofu"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.soysauce).requires((ItemLike)ModBlocks.blockSoyBean).unlockedBy("has_soy", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockSoyBean)).save(consumer, new ResourceLocation("minecolonies", "soysauce"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.cornmeal, (int)3).requires((ItemLike)ModBlocks.blockCorn, 4).unlockedBy("has_corn", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockCorn)).save(consumer, new ResourceLocation("minecolonies", "cornmeal"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.cabochis).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockCabbage).requires((ItemLike)Items.BOWL).requires((ItemLike)com.minecolonies.api.items.ModItems.manchet_bread).unlockedBy("has_cabbage", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockCabbage)).save(consumer, new ResourceLocation("minecolonies", "cabochis"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.congee).requires((ItemLike)ModBlocks.blockCabbage).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)Items.BOWL).requires((ItemLike)com.minecolonies.api.items.ModItems.cooked_rice).unlockedBy("has_cabbage", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockCabbage)).save(consumer, new ResourceLocation("minecolonies", "congee"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.cooked_rice).requires((ItemLike)ModBlocks.blockRice).requires((ItemLike)Items.BOWL).unlockedBy("has_rice", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockRice)).save(consumer, new ResourceLocation("minecolonies", "cooked_rice"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.raw_noodle).requires((ItemLike)ModBlocks.blockDurum).unlockedBy("has_durum", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockDurum)).save(consumer, new ResourceLocation("minecolonies", "raw_noodle"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.pasta_plain).requires((ItemLike)com.minecolonies.api.items.ModItems.raw_noodle).requires((ItemLike)com.minecolonies.api.items.ModItems.butter).requires((ItemLike)Items.BOWL).requires((ItemLike)ModBlocks.blockGarlic).unlockedBy("has_durum", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockDurum)).save(consumer, new ResourceLocation("minecolonies", "pasta_plain"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.pasta_tomato).requires((ItemLike)com.minecolonies.api.items.ModItems.raw_noodle).requires((ItemLike)ModBlocks.blockTomato).requires((ItemLike)ModBlocks.blockTomato).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)Items.BOWL).requires((ItemLike)ModBlocks.blockGarlic).unlockedBy("has_durum", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockDurum)).save(consumer, new ResourceLocation("minecolonies", "pasta_tomato"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.pottage).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)Items.BOWL).requires((ItemLike)Items.POTATO).requires((ItemLike)Items.CARROT).unlockedBy("has_durum", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockDurum)).save(consumer, new ResourceLocation("minecolonies", "pottage"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.rice_ball, (int)2).requires((ItemLike)com.minecolonies.api.items.ModItems.tofu).requires((ItemLike)com.minecolonies.api.items.ModItems.cooked_rice).requires((ItemLike)Items.DRIED_KELP).unlockedBy("has_rice", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockRice)).save(consumer, new ResourceLocation("minecolonies", "rice_ball"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.pepper_hummus, (int)2).requires((ItemLike)ModBlocks.blockBellPepper).requires((ItemLike)ModBlocks.blockBellPepper).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockChickpea).requires((ItemLike)ModBlocks.blockChickpea).unlockedBy("has_chickpea", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockChickpea)).save(consumer, new ResourceLocation("minecolonies", "pepper_hummus"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.mint_jelly, (int)2).requires((ItemLike)ModBlocks.blockMint).requires((ItemLike)ModBlocks.blockMint).requires((ItemLike)ModBlocks.blockMint).requires((ItemLike)com.minecolonies.api.items.ModItems.large_water_bottle).requires((ItemLike)Items.SUGAR).unlockedBy("has_mint", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockMint)).save(consumer, new ResourceLocation("minecolonies", "mint_jelly"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.mint_tea, (int)2).requires((ItemLike)ModBlocks.blockMint).requires((ItemLike)ModBlocks.blockMint).requires((ItemLike)ModBlocks.blockMint).requires((ItemLike)com.minecolonies.api.items.ModItems.large_water_bottle).requires((ItemLike)Items.HONEY_BOTTLE).unlockedBy("has_mint", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockMint)).save(consumer, new ResourceLocation("minecolonies", "mint_tea"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.cheese_ravioli, (int)2).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)com.minecolonies.api.items.ModItems.cheddar_cheese).unlockedBy("has_durum", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockDurum)).save(consumer, new ResourceLocation("minecolonies", "cheese_ravioli"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.chicken_broth, (int)2).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)Items.CHICKEN).requires((ItemLike)Items.BOWL, 2).requires((ItemLike)com.minecolonies.api.items.ModItems.large_water_bottle).unlockedBy("has_durum", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockDurum)).save(consumer, new ResourceLocation("minecolonies", "chicken_broth"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.corn_chowder, (int)2).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockCorn).requires((ItemLike)Items.BOWL, 2).requires((ItemLike)com.minecolonies.api.items.ModItems.large_milk_bottle).unlockedBy("has_corn", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockCorn)).save(consumer, new ResourceLocation("minecolonies", "corn_chowder"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.corn_chowder, (int)2).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockCorn).requires((ItemLike)Items.BOWL, 2).requires((ItemLike)com.minecolonies.api.items.ModItems.large_soy_milk_bottle).unlockedBy("has_corn", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockCorn)).save(consumer, new ResourceLocation("minecolonies", "soy_corn_chowder"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.spicy_grilled_chicken, (int)2).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)Items.CHICKEN).requires((ItemLike)Items.CHICKEN).requires((ItemLike)ModBlocks.blockNetherPepper).unlockedBy("has_nether_pepper", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockNetherPepper)).save(consumer, new ResourceLocation("minecolonies", "spicy_grilled_chicken"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.meat_ravioli, (int)1).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)Items.BEEF).unlockedBy("has_durum", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockDurum)).save(consumer, new ResourceLocation("minecolonies", "meat_ravioli"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.kebab, (int)2).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockNetherPepper).requires((ItemLike)Items.STICK).requires((ItemLike)Items.MUTTON).requires((ItemLike)Items.MUTTON).unlockedBy("has_nether_pepper", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockNetherPepper)).save(consumer, new ResourceLocation("minecolonies", "mutton_kebab"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.pea_soup, (int)2).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockPeas).requires((ItemLike)com.minecolonies.api.items.ModItems.large_milk_bottle).requires((ItemLike)Items.BOWL, 2).unlockedBy("has_peas", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockPeas)).save(consumer, new ResourceLocation("minecolonies", "pea_soup"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.pea_soup, (int)2).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockPeas).requires((ItemLike)com.minecolonies.api.items.ModItems.large_soy_milk_bottle).requires((ItemLike)Items.BOWL, 2).unlockedBy("has_peas", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockPeas)).save(consumer, new ResourceLocation("minecolonies", "soy_pea_soup"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.polenta, (int)2).requires((ItemLike)com.minecolonies.api.items.ModItems.cornmeal).requires((ItemLike)com.minecolonies.api.items.ModItems.cornmeal).requires((ItemLike)com.minecolonies.api.items.ModItems.large_water_bottle).requires((ItemLike)Items.BOWL, 2).unlockedBy("has_corn", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockCorn)).save(consumer, new ResourceLocation("minecolonies", "polenta"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.potato_soup, (int)2).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)Items.POTATO).requires((ItemLike)Items.BOWL, 2).unlockedBy("has_potato", DefaultRecipeProvider.has((ItemLike)Items.POTATO)).save(consumer, new ResourceLocation("minecolonies", "potato_soup"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.squash_soup, (int)2).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockButternutSquash).requires((ItemLike)Items.BOWL, 2).unlockedBy("has_squash", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockButternutSquash)).save(consumer, new ResourceLocation("minecolonies", "squash_soup"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.tortillas, (int)2).requires((ItemLike)com.minecolonies.api.items.ModItems.cornmeal).requires((ItemLike)com.minecolonies.api.items.ModItems.cornmeal).unlockedBy("has_corn", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockCorn)).save(consumer, new ResourceLocation("minecolonies", "tortillas"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.veggie_ravioli, (int)1).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)Items.BEETROOT).unlockedBy("has_durum", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockDurum)).save(consumer, new ResourceLocation("minecolonies", "veggie_ravioli"));
        ZeroWasteRecipe.build(RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.large_soy_milk_bottle, 1).requires((ItemLike)com.minecolonies.api.items.ModItems.large_water_bottle).requires((ItemLike)ModBlocks.blockSoyBean).unlockedBy("has_soy", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockSoyBean)).save(consumer, new ResourceLocation("minecolonies", "soy_milk"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.yogurt, (int)1).requires((ItemLike)com.minecolonies.api.items.ModItems.large_milk_bottle).unlockedBy("has_milk", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.large_milk_bottle)).save(consumer, new ResourceLocation("minecolonies", "yogurt"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.yogurt, (int)1).requires((ItemLike)com.minecolonies.api.items.ModItems.large_soy_milk_bottle).unlockedBy("has_soy_milk", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.large_soy_milk_bottle)).save(consumer, new ResourceLocation("minecolonies", "soy_yogurt"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.baked_salmon, (int)2).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)Items.SALMON).requires((ItemLike)Items.SALMON).unlockedBy("has_garlic", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockGarlic)).save(consumer, new ResourceLocation("minecolonies", "baked_salmon"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.eggdrop_soup, (int)2).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)Items.EGG).requires((ItemLike)Items.EGG).requires((ItemLike)Items.CHICKEN).unlockedBy("has_onion", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockOnion)).save(consumer, new ResourceLocation("minecolonies", "eggdrop_soup"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.fish_n_chips, (int)1).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)Items.SALMON).requires((ItemLike)Items.POTATO).unlockedBy("has_durum", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockDurum)).save(consumer, new ResourceLocation("minecolonies", "fish_n_chips"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.kimchi, (int)1).requires((ItemLike)ModBlocks.blockCabbage).requires((ItemLike)ModBlocks.blockCabbage).requires((ItemLike)ModBlocks.blockNetherPepper).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)Items.CARROT).requires((ItemLike)Items.BOWL).unlockedBy("has_nether_pepper", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockNetherPepper)).save(consumer, new ResourceLocation("minecolonies", "kimchi"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.pierogi, (int)1).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)com.minecolonies.api.items.ModItems.cheddar_cheese).requires((ItemLike)Items.POTATO).unlockedBy("has_cheddar", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.cheddar_cheese)).save(consumer, new ResourceLocation("minecolonies", "pierogi"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.veggie_quiche, (int)2).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockButternutSquash).requires((ItemLike)ModBlocks.blockButternutSquash).requires((ItemLike)com.minecolonies.api.items.ModItems.large_water_bottle).unlockedBy("has_squash", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockButternutSquash)).save(consumer, new ResourceLocation("minecolonies", "veggie_quiche"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.veggie_soup, (int)1).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)ModBlocks.blockEggplant).requires((ItemLike)Items.CARROT).requires((ItemLike)Items.BOWL).unlockedBy("has_eggplant", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockEggplant)).save(consumer, new ResourceLocation("minecolonies", "veggie_soup"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.yogurt_with_berries, (int)2).requires((ItemLike)com.minecolonies.api.items.ModItems.yogurt).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)Items.SWEET_BERRIES).requires((ItemLike)Items.BOWL, 2).unlockedBy("has_yogurt", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.yogurt)).save(consumer, new ResourceLocation("minecolonies", "yogurt_with_berries"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.mutton_dinner, (int)1).requires((ItemLike)ModBlocks.blockPeas).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)Items.MUTTON).requires((ItemLike)Items.POTATO).unlockedBy("has_mutton", DefaultRecipeProvider.has((ItemLike)Items.MUTTON)).save(consumer, new ResourceLocation("minecolonies", "mutton_dinner"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.apple_pie, (int)1).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)Items.APPLE).requires((ItemLike)Items.APPLE).requires((ItemLike)Items.SUGAR).unlockedBy("has_apple", DefaultRecipeProvider.has((ItemLike)Items.APPLE)).save(consumer, new ResourceLocation("minecolonies", "apple_pie"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.cheese_pizza, (int)2).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)ModBlocks.blockTomato).requires((ItemLike)ModBlocks.blockTomato).requires((ItemLike)ModBlocks.blockGarlic).requires((ItemLike)com.minecolonies.api.items.ModItems.cheddar_cheese).unlockedBy("has_cheddar", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.cheddar_cheese)).save(consumer, new ResourceLocation("minecolonies", "cheese_pizza"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.plain_cheesecake, (int)1).requires((ItemLike)com.minecolonies.api.items.ModItems.creamcheese).requires((ItemLike)com.minecolonies.api.items.ModItems.creamcheese).requires((ItemLike)ModBlocks.blockDurum).requires((ItemLike)com.minecolonies.api.items.ModItems.butter).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.EGG).requires((ItemLike)Items.EGG).unlockedBy("has_butter", DefaultRecipeProvider.has((ItemLike)com.minecolonies.api.items.ModItems.butter)).save(consumer, new ResourceLocation("minecolonies", "plain_cheesecake"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)com.minecolonies.api.items.ModItems.fried_rice, (int)1).requires((ItemLike)ModBlocks.blockOnion).requires((ItemLike)Items.CARROT).requires((ItemLike)com.minecolonies.api.items.ModItems.cooked_rice).requires((ItemLike)Items.EGG).requires(ModTags.rawMeat).unlockedBy("has_onion", DefaultRecipeProvider.has((ItemLike)ModBlocks.blockOnion)).save(consumer, new ResourceLocation("minecolonies", "fried_rice"));
    }
}

