/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.items.ModItems;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantedCountIncreaseFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class DefaultEntityLootProvider
extends EntityLootSubProvider {
    public DefaultEntityLootProvider(@NotNull HolderLookup.Provider provider) {
        super(FeatureFlags.REGISTRY.allFlags(), provider);
    }

    public void generate() {
        this.registerLoot(ModEntities.AMAZON, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(5)));
        this.registerLoot(ModEntities.AMAZONSPEARMAN, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.spear).setWeight(15)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(5)));
        this.registerLoot(ModEntities.AMAZONCHIEF, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW).setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(30)));
        this.registerLoot(ModEntities.BARBARIAN, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_AXE).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_AXE).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_AXE).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_AXE).setWeight(6)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(3)));
        this.registerLoot(ModEntities.ARCHERBARBARIAN, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(5)));
        this.registerLoot(ModEntities.CHIEFBARBARIAN, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.chiefSword).setWeight(1).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_SWORD).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_SWORD).setWeight(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_SWORD).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_SWORD).setWeight(20)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(30)));
        this.registerLoot(ModEntities.SHIELDMAIDEN, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHIELD).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(5)));
        this.registerLoot(ModEntities.NORSEMEN_ARCHER, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(5)));
        this.registerLoot(ModEntities.NORSEMEN_CHIEF, builder -> builder.setRolls((NumberProvider)ConstantValue.exactly((float)2.0f)).add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER).setWeight(15).setQuality(5)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_AXE).setWeight(10).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(50)));
        this.registerLoot(ModEntities.PIRATE, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.scimitar).setWeight(6)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(4)));
        this.registerLoot(ModEntities.ARCHERPIRATE, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(5)));
        this.registerLoot(ModEntities.CHIEFPIRATE, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateHelmet_1).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateLegs_1).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateBoots_1).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateChest_1).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateHelmet_2).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateLegs_2).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateBoots_2).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateChest_2).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.scimitar).setWeight(25).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(30)));
        this.registerLoot(ModEntities.MUMMY, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(15)));
        this.registerLoot(ModEntities.ARCHERMUMMY, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(5)));
        this.registerLoot(ModEntities.PHARAO, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pharaoscepter).setWeight(3).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ARROW).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)16.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)1.0f, (float)32.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.firearrow).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)16.0f))).apply((LootItemFunction.Builder)EnchantedCountIncreaseFunction.lootingMultiplier((HolderLookup.Provider)this.registries, (NumberProvider)UniformGenerator.between((float)1.0f, (float)32.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(30)));
        this.registerLoot(ModEntities.DROWNED_PIRATE, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.scimitar).setWeight(6)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(4)));
        this.registerLoot(ModEntities.DROWNED_ARCHERPIRATE, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(80)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW).setWeight(10)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(5)));
        this.registerLoot(ModEntities.DROWNED_CHIEFPIRATE, builder -> builder.add((LootPoolEntryContainer.Builder)EmptyLootItem.emptyItem().setWeight(50)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateHelmet_1).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateLegs_1).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateBoots_1).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateChest_1).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateHelmet_2).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateLegs_2).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateBoots_2).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.pirateChest_2).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.scimitar).setWeight(25).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)ModItems.ancientTome).setWeight(30)));
    }

    private void registerLoot(@NotNull EntityType<?> entity, @NotNull Consumer<LootPool.Builder> builder) {
        ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey(entity);
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f));
        builder.accept(pool);
        this.add(entity, entity.getDefaultLootTable(), LootTable.lootTable().withPool(pool));
    }

    protected Stream<EntityType<?>> getKnownEntityTypes() {
        return ModEntities.getRaiders().stream().map(EntityType.class::cast);
    }
}

