/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingOutputStream;
import com.minecolonies.api.util.Log;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.Util;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.resource.ResourcePackLoader;
import net.neoforged.neoforgespi.language.IModFileInfo;
import org.jetbrains.annotations.NotNull;

public class DefaultEntityIconProvider
implements DataProvider {
    private final DataGenerator generator;

    public DefaultEntityIconProvider(@NotNull DataGenerator generator) {
        this.generator = generator;
    }

    @NotNull
    public String getName() {
        return "Default Citizen Icons";
    }

    private static boolean IsEntitySkin(@NotNull ResourceLocation id) {
        return id.getPath().endsWith(".png") && (id.getPath().startsWith("textures/entity/citizen/") || id.getPath().startsWith("textures/entity/raiders/"));
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        PackOutput.PathProvider outputProvider = this.generator.getPackOutput().createPathProvider(PackOutput.Target.RESOURCE_PACK, "textures/entity_icon");
        IModFileInfo modFileInfo = ModList.get().getModFileById("minecolonies");
        try (PackResources pack = ResourcePackLoader.createPackForMod((IModFileInfo)modFileInfo).openPrimary(new PackLocationInfo("mod/minecolonies", (Component)Component.empty(), PackSource.BUILT_IN, Optional.empty()));){
            ArrayList icons = new ArrayList();
            pack.listResources(PackType.CLIENT_RESOURCES, "minecolonies", "textures/entity", (id, stream) -> {
                if (DefaultEntityIconProvider.IsEntitySkin(id)) {
                    ResourceLocation iconId = new ResourceLocation(id.getNamespace(), id.getPath().replace("textures/entity/", "").replace(".png", ""));
                    icons.add(this.generateIcon(outputProvider, iconId, (IoSupplier<InputStream>)stream, cache));
                }
            });
            CompletableFuture<Void> completableFuture = CompletableFuture.allOf((CompletableFuture[])icons.toArray(CompletableFuture[]::new));
            return completableFuture;
        }
    }

    private CompletableFuture<?> generateIcon(@NotNull PackOutput.PathProvider outputProvider, @NotNull ResourceLocation id, @NotNull IoSupplier<InputStream> inputSupplier, @NotNull CachedOutput cache) {
        return CompletableFuture.runAsync(() -> {
            try (NativeImage skin = NativeImage.read((InputStream)((InputStream)inputSupplier.get()));
                 NativeImage icon = DefaultEntityIconProvider.createIconForSkin(skin);){
                DefaultEntityIconProvider.saveIcon(outputProvider, id, icon, cache);
            }
            catch (IOException e) {
                Log.getLogger().error("Failed to save file to {}", (Object)id, (Object)e);
            }
        }, Util.backgroundExecutor());
    }

    private static NativeImage createIconForSkin(@NotNull NativeImage skin) {
        NativeImage icon = new NativeImage(16, 16, false);
        skin.resizeSubRectTo(8, 8, 8, 8, icon);
        for (int i = 0; i < 16; ++i) {
            icon.blendPixel(0, i, Integer.MIN_VALUE);
            icon.blendPixel(15, i, Integer.MIN_VALUE);
            if (i <= 0 || i >= 15) continue;
            icon.blendPixel(i, 0, Integer.MIN_VALUE);
            icon.blendPixel(i, 15, Integer.MIN_VALUE);
        }
        return icon;
    }

    private static void saveIcon(@NotNull PackOutput.PathProvider outputProvider, @NotNull ResourceLocation id, @NotNull NativeImage icon, @NotNull CachedOutput cache) throws IOException {
        BufferedImage image;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(icon.asByteArray());){
            image = ImageIO.read(stream);
        }
        BufferedImage optimized = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        optimized.getGraphics().drawImage(image, 0, 0, null);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        HashingOutputStream hashStream = new HashingOutputStream(Hashing.sha1(), (OutputStream)outputStream);
        ImageIO.write((RenderedImage)optimized, "PNG", (OutputStream)hashStream);
        cache.writeIfNeeded(outputProvider.file(id, "png"), outputStream.toByteArray(), hashStream.hash());
    }
}

