/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class DatagenLootTableManager
implements HolderLookup.Provider {
    private final HolderLookup.Provider baseProvider;
    private final ExistingFileHelper existingFileHelper;
    private final Registry<LootTable> registry = new DynamicLoadingRegistry(Registries.LOOT_TABLE, Lifecycle.stable(), false, LootTable.DIRECT_CODEC);

    public DatagenLootTableManager(@NotNull HolderLookup.Provider baseProvider, @NotNull ExistingFileHelper existingFileHelper) {
        this.baseProvider = baseProvider;
        this.existingFileHelper = existingFileHelper;
    }

    @NotNull
    public Stream<ResourceKey<? extends Registry<?>>> listRegistries() {
        return this.baseProvider.listRegistries();
    }

    @NotNull
    public <T> Optional<HolderLookup.RegistryLookup<T>> lookup(@NotNull ResourceKey<? extends Registry<? extends T>> registryId) {
        if (registryId.equals((Object)Registries.LOOT_TABLE)) {
            return Optional.of(this.registry.asLookup());
        }
        return this.baseProvider.lookup(registryId);
    }

    @NotNull
    public <V> RegistryOps<V> createSerializationContext(@NotNull DynamicOps<V> ops) {
        return this.baseProvider.createSerializationContext(ops);
    }

    private class DynamicLoadingRegistry<T>
    extends MappedRegistry<T> {
        private final Codec<T> codec;

        public DynamicLoadingRegistry(@NotNull ResourceKey<? extends Registry<T>> registryId, Lifecycle lifecycle, @NotNull boolean intrusive, Codec<T> codec) {
            super(registryId, lifecycle, intrusive);
            this.codec = codec;
        }

        @NotNull
        public Optional<Holder.Reference<T>> getHolder(@NotNull ResourceKey<T> id) {
            if (super.containsKey(id)) {
                return super.getHolder(id);
            }
            Optional<Object> table = this.dynamicLoad(id);
            return table.map(lt -> this.register(id, lt, RegistrationInfo.BUILT_IN));
        }

        private Optional<T> dynamicLoad(@NotNull ResourceKey<T> id) {
            Optional<Object> optional;
            block8: {
                Resource resource = DatagenLootTableManager.this.existingFileHelper.getResource(id.location(), PackType.SERVER_DATA, ".json", Registries.elementsDirPath((ResourceKey)this.key()));
                RegistryOps ops = DatagenLootTableManager.this.createSerializationContext(JsonOps.INSTANCE);
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    optional = Optional.of(((Pair)this.codec.decode(ops, (Object)json).getOrThrow()).getFirst());
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        return Optional.empty();
                    }
                }
                reader.close();
            }
            return optional;
        }
    }
}

