/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.ISearchPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PathJobWalkRandomEdge
extends AbstractPathJob
implements ISearchPathJob {
    private static final int NODE_EDGE_CHANCE = 10;
    private final BlockPos searchAroundPos;

    public PathJobWalkRandomEdge(Level world, @NotNull BlockPos searchAroundPos, int range, Mob entity) {
        super(world, PathfindingUtils.prepareStart((LivingEntity)entity), range, new PathResult(), entity);
        this.searchAroundPos = searchAroundPos;
        this.extraNodes = 20;
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.distManhattan(this.searchAroundPos, x, y, z);
    }

    @Override
    public void setPathingOptions(PathingOptions pathingOptions) {
        super.setPathingOptions(pathingOptions);
        pathingOptions.canDrop = false;
    }

    @Override
    protected boolean isAtDestination(MNode n) {
        if (this.searchAroundPos.getY() - n.y > 3 || this.searchAroundPos.getY() - n.y < -3) {
            return false;
        }
        return ColonyConstants.rand.nextInt(10) == 0 && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.set(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
    }

    @Override
    public double getEndNodeScore(MNode n) {
        return -BlockPosUtil.distManhattan(this.searchAroundPos, n.x, n.y, n.z);
    }
}

