/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.other;

import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.loot.ModLootTables;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.event.EventHooks;

public class NewBobberEntity
extends Projectile
implements IEntityWithComplexSpawn {
    public static final int XP_PER_CATCH = 2;
    private static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.defineId(NewBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.defineId(NewBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final RandomSource syncronizedRandom = RandomSource.create();
    private boolean biting;
    private int outOfWaterTime;
    private int life;
    private int nibble;
    private int timeUntilLured;
    private int timeUntilHooked;
    private float fishAngle;
    private boolean openWater = true;
    @Nullable
    private Entity hookedEntity;
    private BobberState currentState = BobberState.FLYING;
    private final int luck;
    private final int lureSpeed;

    private NewBobberEntity(EntityType<? extends Projectile> type, Level level, int luck, int lure) {
        super(type, level);
        this.noCulling = true;
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lure);
    }

    public NewBobberEntity(EntityType<? extends Projectile> type, Level level) {
        this(type, level, 0, 0);
    }

    public NewBobberEntity(EntityType<? extends Projectile> type, AbstractEntityCitizen citizen, Level level, int luck, int lure) {
        this(type, level, luck, lure);
        this.setOwner((Entity)citizen);
        float f = citizen.getXRot();
        float f1 = citizen.getYRot();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        double d0 = citizen.getX() - (double)f3 * 0.3;
        double d1 = citizen.getEyeY();
        double d2 = citizen.getZ() - (double)f2 * 0.3;
        this.moveTo(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.clamp((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.length();
        vec3 = vec3.multiply(0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365), 0.6 / d3 + this.random.triangle(0.5, 0.0103365));
        this.setDeltaMovement(vec3);
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 180.0 / 3.1415927410125732));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 180.0 / 3.1415927410125732));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_HOOKED_ENTITY, (Object)0);
        builder.define(DATA_BITING, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_37153_) {
        if (DATA_HOOKED_ENTITY.equals(p_37153_)) {
            int i = (Integer)this.getEntityData().get(DATA_HOOKED_ENTITY);
            Entity entity = this.hookedEntity = i > 0 ? this.level().getEntity(i - 1) : null;
        }
        if (DATA_BITING.equals(p_37153_)) {
            this.biting = (Boolean)this.getEntityData().get(DATA_BITING);
            if (this.biting) {
                this.setDeltaMovement(this.getDeltaMovement().x, -0.4f * Mth.nextFloat((RandomSource)this.syncronizedRandom, (float)0.6f, (float)1.0f), this.getDeltaMovement().z);
            }
        }
        super.onSyncedDataUpdated(p_37153_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderAtSqrDistance(double distance) {
        return distance < 4096.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void lerpTo(double x, double y, double z, float yaw, float pitch, int posRotationIncrements) {
    }

    public void tick() {
        this.syncronizedRandom.setSeed(this.getUUID().getLeastSignificantBits() ^ this.level().getGameTime());
        super.tick();
        AbstractEntityCitizen citizen = (AbstractEntityCitizen)this.getOwner();
        if (citizen == null) {
            this.discard();
        } else if (this.level().isClientSide || !this.shouldStopFishing(citizen)) {
            boolean flag;
            if (this.onGround()) {
                ++this.life;
                if (this.life >= 1200) {
                    this.discard();
                    return;
                }
            } else {
                this.life = 0;
            }
            float f = 0.0f;
            BlockPos blockpos = this.blockPosition();
            FluidState fluidstate = this.level().getFluidState(blockpos);
            if (fluidstate.is(FluidTags.WATER)) {
                f = fluidstate.getHeight((BlockGetter)this.level(), blockpos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.currentState == BobberState.FLYING) {
                if (this.hookedEntity != null) {
                    this.setDeltaMovement(Vec3.ZERO);
                    this.currentState = BobberState.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
                    this.currentState = BobberState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == BobberState.HOOKED_IN_ENTITY) {
                    if (this.hookedEntity != null) {
                        if (!this.hookedEntity.isRemoved() && this.hookedEntity.level().dimension() == this.level().dimension()) {
                            this.setPos(this.hookedEntity.getX(), this.hookedEntity.getY(0.8), this.hookedEntity.getZ());
                        } else {
                            this.setHookedEntity(null);
                            this.currentState = BobberState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == BobberState.BOBBING) {
                    Vec3 vec3 = this.getDeltaMovement();
                    double d0 = this.getY() + vec3.y - (double)blockpos.getY() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.setDeltaMovement(vec3.x * 0.9, vec3.y - d0 * (double)this.random.nextFloat() * 0.2, vec3.z * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openWater = true;
                    } else {
                        boolean bl2 = this.openWater = this.openWater && this.outOfWaterTime < 10 && this.calculateOpenWater(blockpos);
                    }
                    if (flag) {
                        this.outOfWaterTime = Math.max(0, this.outOfWaterTime - 1);
                        if (this.biting) {
                            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1 * (double)this.syncronizedRandom.nextFloat() * (double)this.syncronizedRandom.nextFloat(), 0.0));
                        }
                        if (!this.level().isClientSide) {
                            this.catchingFish(blockpos);
                        }
                    } else {
                        this.outOfWaterTime = Math.min(10, this.outOfWaterTime + 1);
                    }
                }
            }
            if (!fluidstate.is(FluidTags.WATER)) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.updateRotation();
            if (this.currentState == BobberState.FLYING && (this.onGround() || this.horizontalCollision)) {
                this.setDeltaMovement(Vec3.ZERO);
            }
            double d1 = 0.92;
            this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
            this.reapplyPosition();
        }
    }

    public boolean shouldStopFishing(AbstractEntityCitizen citizen) {
        ItemStack mainHandItem = citizen.getMainHandItem();
        ItemStack offHandItem = citizen.getOffhandItem();
        boolean flag = mainHandItem.canPerformAction(ItemAbilities.FISHING_ROD_CAST);
        boolean flag1 = offHandItem.canPerformAction(ItemAbilities.FISHING_ROD_CAST);
        if (!citizen.isRemoved() && citizen.isAlive() && (flag || flag1) && !(this.distanceToSqr((Entity)citizen) > 1024.0)) {
            return false;
        }
        this.discard();
        return true;
    }

    private void checkCollision() {
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        if (hitresult.getType() == HitResult.Type.MISS || !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.onHit(hitresult);
        }
    }

    protected boolean canHitEntity(Entity hitEntity) {
        return super.canHitEntity(hitEntity) || hitEntity.isAlive() && hitEntity instanceof ItemEntity;
    }

    protected void onHitEntity(EntityHitResult hitEntity) {
        super.onHitEntity(hitEntity);
        if (!this.level().isClientSide) {
            this.setHookedEntity(hitEntity.getEntity());
        }
    }

    protected void onHitBlock(BlockHitResult hitBlock) {
        super.onHitBlock(hitBlock);
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(hitBlock.distanceTo((Entity)this)));
    }

    private void setHookedEntity(@Nullable Entity hookedEntity) {
        this.hookedEntity = hookedEntity;
        this.getEntityData().set(DATA_HOOKED_ENTITY, (Object)(hookedEntity == null ? 0 : hookedEntity.getId() + 1));
    }

    private void catchingFish(BlockPos p_37146_) {
        ServerLevel serverlevel = (ServerLevel)this.level();
        int i = 1;
        BlockPos blockpos = p_37146_.above();
        if (this.random.nextFloat() < 0.25f && this.level().isRainingAt(blockpos)) {
            ++i;
        }
        if (this.random.nextFloat() < 0.5f && !this.level().canSeeSky(blockpos)) {
            --i;
        }
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilLured = 0;
                this.timeUntilHooked = 0;
                this.getEntityData().set(DATA_BITING, (Object)false);
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= i;
            if (this.timeUntilHooked > 0) {
                double d2;
                double d1;
                this.fishAngle += (float)this.random.triangle(0.0, 9.188);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float f1 = Mth.sin((float)f);
                float f2 = Mth.cos((float)f);
                double d0 = this.getX() + (double)(f1 * (float)this.timeUntilHooked * 0.1f);
                BlockState blockstate = serverlevel.getBlockState(BlockPos.containing((double)d0, (double)((d1 = (double)((float)Mth.floor((double)this.getY()) + 1.0f)) - 1.0), (double)(d2 = this.getZ() + (double)(f2 * (float)this.timeUntilHooked * 0.1f))));
                if (blockstate.is(Blocks.WATER)) {
                    if (this.random.nextFloat() < 0.15f) {
                        serverlevel.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    serverlevel.sendParticles((ParticleOptions)ParticleTypes.FISHING, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    serverlevel.sendParticles((ParticleOptions)ParticleTypes.FISHING, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                double d3 = this.getY() + 0.5;
                serverlevel.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                serverlevel.sendParticles((ParticleOptions)ParticleTypes.FISHING, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                this.nibble = Mth.nextInt((RandomSource)this.random, (int)20, (int)40);
                this.getEntityData().set(DATA_BITING, (Object)true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= i;
            float f5 = 0.15f;
            if (this.timeUntilLured < 20) {
                f5 += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                f5 += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                f5 += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.random.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = Mth.nextFloat((RandomSource)this.random, (float)25.0f, (float)60.0f);
                double d4 = this.getX() + (double)(Mth.sin((float)f6) * f7) * 0.1;
                BlockState blockstate1 = serverlevel.getBlockState(BlockPos.containing((double)d4, (double)((d5 = (double)((float)Mth.floor((double)this.getY()) + 1.0f)) - 1.0), (double)(d6 = this.getZ() + (double)(Mth.cos((float)f6) * f7) * 0.1)));
                if (blockstate1.is(Blocks.WATER)) {
                    serverlevel.sendParticles((ParticleOptions)ParticleTypes.SPLASH, d4, d5, d6, 2 + this.random.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = Mth.nextInt((RandomSource)this.random, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = Mth.nextInt((RandomSource)this.random, (int)100, (int)600);
            this.timeUntilLured -= this.lureSpeed;
        }
    }

    private boolean calculateOpenWater(BlockPos p_37159_) {
        OpenWaterType openWaterType = OpenWaterType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            OpenWaterType localOpenWaterType = this.getOpenWaterTypeForArea(p_37159_.offset(-2, i, -2), p_37159_.offset(2, i, 2));
            switch (localOpenWaterType.ordinal()) {
                case 0: {
                    if (openWaterType != OpenWaterType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (openWaterType != OpenWaterType.ABOVE_WATER) break;
                    return false;
                }
                case 2: {
                    return false;
                }
            }
            openWaterType = localOpenWaterType;
        }
        return true;
    }

    private OpenWaterType getOpenWaterTypeForArea(BlockPos p_37148_, BlockPos p_37149_) {
        return BlockPos.betweenClosedStream((BlockPos)p_37148_, (BlockPos)p_37149_).map(this::getOpenWaterTypeForBlock).reduce((p_37139_, p_37140_) -> p_37139_ == p_37140_ ? p_37139_ : OpenWaterType.INVALID).orElse(OpenWaterType.INVALID);
    }

    private OpenWaterType getOpenWaterTypeForBlock(BlockPos p_37164_) {
        BlockState blockstate = this.level().getBlockState(p_37164_);
        if (!blockstate.isAir() && !blockstate.is(Blocks.LILY_PAD)) {
            FluidState fluidstate = blockstate.getFluidState();
            return fluidstate.is(FluidTags.WATER) && fluidstate.isSource() && blockstate.getCollisionShape((BlockGetter)this.level(), p_37164_).isEmpty() ? OpenWaterType.INSIDE_WATER : OpenWaterType.INVALID;
        }
        return OpenWaterType.ABOVE_WATER;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
    }

    public void readAdditionalSaveData(CompoundTag tag) {
    }

    public int retrieve(ItemStack p_37157_) {
        AbstractEntityCitizen citizen = (AbstractEntityCitizen)this.getOwner();
        if (!this.level().isClientSide && citizen != null && !this.shouldStopFishing(citizen)) {
            int i = 0;
            if (this.hookedEntity != null) {
                this.pullEntity(this.hookedEntity);
                this.level().broadcastEntityEvent((Entity)this, (byte)31);
                i = this.hookedEntity instanceof ItemEntity ? 3 : 5;
            } else if (this.nibble > 0) {
                LootParams lootparams = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)p_37157_).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)this.getOwner()).withLuck((float)this.luck).create(LootContextParamSets.FISHING);
                LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(ModLootTables.FISHING);
                ObjectArrayList list = loottable.getRandomItems(lootparams);
                for (ItemStack itemstack : list) {
                    ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemstack);
                    double d0 = citizen.getX() - this.getX();
                    double d1 = citizen.getY() - this.getY();
                    double d2 = citizen.getZ() - this.getZ();
                    itementity.setDeltaMovement(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.level().addFreshEntity((Entity)itementity);
                    citizen.level().addFreshEntity((Entity)new ExperienceOrb(citizen.level(), citizen.getX(), citizen.getY() + 0.5, citizen.getZ() + 0.5, this.random.nextInt(6) + 1));
                }
                i = 1;
            }
            if (this.onGround()) {
                i = 2;
            }
            this.discard();
            return i;
        }
        return 0;
    }

    public void handleEntityEvent(byte b) {
        if (b == 31 && this.level().isClientSide && this.hookedEntity instanceof Player && ((Player)this.hookedEntity).isLocalPlayer()) {
            this.pullEntity(this.hookedEntity);
        }
        super.handleEntityEvent(b);
    }

    protected void pullEntity(Entity entityToPull) {
        Entity entity = this.getOwner();
        if (entity != null) {
            Vec3 vec3 = new Vec3(entity.getX() - this.getX(), entity.getY() - this.getY(), entity.getZ() - this.getZ()).scale(0.1);
            entityToPull.setDeltaMovement(entityToPull.getDeltaMovement().add(vec3));
        }
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Nullable
    public Entity getHookedEntity() {
        return this.hookedEntity;
    }

    public boolean canUsePortal(boolean p_352895_) {
        return false;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
    }

    public boolean isReadyToCatch() {
        return this.biting;
    }

    public void setInUse() {
        this.life = 100;
    }

    static enum BobberState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    static enum OpenWaterType {
        ABOVE_WATER,
        INSIDE_WATER,
        INVALID;

    }
}

