/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.other;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.core.colony.jobs.JobDruid;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DruidPotionEntity
extends ThrownPotion {
    public static final double SPLASH_SIZE = 4.0;
    public static final double SPLASH_HEIGTH = 2.0;
    public static final double MAX_DISTANCE = 16.0;
    public static final int MIN_DURATION = 20;
    @Nullable
    private BiPredicate<LivingEntity, MobEffect> entitySelectionPredicate = null;

    public DruidPotionEntity(EntityType<? extends ThrownPotion> type, Level world) {
        super(type, world);
    }

    public void setEntitySelectionPredicate(@Nullable BiPredicate<LivingEntity, MobEffect> entitySelectionPredicate) {
        this.entitySelectionPredicate = entitySelectionPredicate;
    }

    public void applySplash(Iterable<MobEffectInstance> effects, @Nullable Entity entity) {
        AbstractEntityCitizen citizen = this.getOwner();
        if (citizen != null && citizen.getCitizenData() != null && citizen.getCitizenData().getJob() instanceof JobDruid) {
            AABB axisalignedbb = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
            List list = this.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb);
            if (!list.isEmpty()) {
                for (LivingEntity livingentity : list) {
                    double distanceSq;
                    if (!livingentity.isAffectedByPotions() || !((distanceSq = this.distanceToSqr((Entity)livingentity)) < 16.0)) continue;
                    double d1 = 1.0 - Math.sqrt(distanceSq) / 4.0;
                    if (livingentity == entity) {
                        d1 = 1.0;
                    }
                    for (MobEffectInstance effectinstance : effects) {
                        MobEffect effect = (MobEffect)effectinstance.getEffect().value();
                        if (this.entitySelectionPredicate != null && !this.entitySelectionPredicate.test(livingentity, effect)) continue;
                        if (effect.isInstantenous()) {
                            effect.applyInstantenousEffect((Entity)this, (Entity)this.getOwner(), livingentity, effectinstance.getAmplifier(), d1);
                            continue;
                        }
                        int duration = (int)(d1 * (double)effectinstance.getDuration());
                        livingentity.addEffect(new MobEffectInstance(effectinstance.getEffect(), duration, effectinstance.getAmplifier(), effectinstance.isAmbient(), effectinstance.isVisible()));
                    }
                }
            }
        }
    }

    @Nullable
    public AbstractEntityCitizen getOwner() {
        Entity owner = super.getOwner();
        if (owner instanceof AbstractEntityCitizen) {
            return (AbstractEntityCitizen)owner;
        }
        return null;
    }

    public static void throwPotionAt(ItemStack potionStack, LivingEntity target, AbstractEntityCitizen thrower, Level world, float velocity, float inaccuracy, BiPredicate<LivingEntity, MobEffect> entitySelectionPredicate) {
        DruidPotionEntity potionentity = (DruidPotionEntity)ModEntities.DRUID_POTION.create(world);
        potionentity.setOwner((Entity)thrower);
        potionentity.setEntitySelectionPredicate(entitySelectionPredicate);
        potionentity.setItem(potionStack);
        potionentity.setPos(thrower.getX(), thrower.getY() + 1.0, thrower.getZ());
        thrower.level().playSound(null, thrower.getX(), thrower.getY(), thrower.getZ(), SoundEvents.WITCH_THROW, thrower.getSoundSource(), 1.0f, 0.8f + thrower.getRandom().nextFloat() * 0.4f);
        Vec3 movement = target.getDeltaMovement();
        double x = target.getX() + movement.x - thrower.getX();
        double y = target.getEyeY() - (double)1.1f - thrower.getY();
        double z = target.getZ() + movement.z - thrower.getZ();
        double distance = Math.sqrt(x * x + z * z);
        potionentity.shoot(x, y + distance * 0.2, z, velocity, inaccuracy);
        world.addFreshEntity((Entity)potionentity);
    }
}

