/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.mobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyRelated;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.sounds.MercenarySounds;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.mobs.EntityMercenaryAI;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.proxy.GeneralEntityWalkToProxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityMercenary
extends AbstractFastMinecoloniesEntity
implements Npc,
IColonyRelated {
    private static final int SLAP_INTERVAL = 100;
    private IColony colony;
    private AbstractAdvancedPathNavigate newNavigator;
    private GeneralEntityWalkToProxy proxy;
    private int slapTimer = 0;
    private final Random rand = new Random();
    private long worldTimeAtSpawn = 0L;
    private boolean isLeader = false;
    private List<EntityMercenary> soldiers = new ArrayList<EntityMercenary>();
    private int spawnEventTime = 0;
    private boolean doSpawnEvent = false;
    private ITickRateStateMachine<IState> stateMachine;
    private static final String ENTITY_NAME = "Mercenary";
    private int colonyId;

    public EntityMercenary(EntityType<EntityMercenary> type, Level world) {
        super(type, world);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new EntityMercenaryAI(this));
        this.goalSelector.addGoal(4, (Goal)new EntityAIInteractToggleAble(this, EntityAIInteractToggleAble.FENCE_TOGGLE, EntityAIInteractToggleAble.TRAP_TOGGLE, EntityAIInteractToggleAble.DOOR_TOGGLE));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, 10, true, false, e -> e instanceof Enemy && !(e instanceof Llama)));
        this.setCustomNameVisible(true);
        this.setPersistenceRequired();
        ItemStack mainhand = new ItemStack((ItemLike)Items.GOLDEN_SWORD, 1);
        mainhand.enchant(Utils.getRegistryValue(Enchantments.FIRE_ASPECT, world), 1);
        this.setItemSlot(EquipmentSlot.MAINHAND, mainhand);
        ItemStack helmet = new ItemStack((ItemLike)Items.DIAMOND_HELMET, 1);
        helmet.enchant(Utils.getRegistryValue(Enchantments.PROTECTION, world), 4);
        this.setItemSlot(EquipmentSlot.HEAD, helmet);
        ItemStack chest = new ItemStack((ItemLike)Items.GOLDEN_CHESTPLATE, 1);
        chest.enchant(Utils.getRegistryValue(Enchantments.PROTECTION, world), 4);
        this.setItemSlot(EquipmentSlot.CHEST, chest);
        ItemStack legs = new ItemStack((ItemLike)Items.CHAINMAIL_LEGGINGS, 1);
        this.setItemSlot(EquipmentSlot.LEGS, legs);
        ItemStack boots = new ItemStack((ItemLike)Items.CHAINMAIL_BOOTS, 1);
        this.setItemSlot(EquipmentSlot.FEET, boots);
        this.getAttribute(Attributes.FOLLOW_RANGE).setBaseValue(35.0);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.3);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(60.0);
        this.setHealth(this.getMaxHealth());
        this.stateMachine = new TickRateStateMachine<EntityMercenaryAI.State>(EntityMercenaryAI.State.INIT, this::handleStateException);
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.INIT, this::isInitialized, () -> EntityMercenaryAI.State.SPAWN_EVENT, 20));
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.SPAWN_EVENT, this::spawnEvent, () -> EntityMercenaryAI.State.ALIVE, 30));
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.ALIVE, this::shouldDespawn, () -> EntityMercenaryAI.State.DEAD, 100));
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.DEAD, () -> true, this::getState, 500));
    }

    private void handleStateException(RuntimeException e) {
        Log.getLogger().warn("Mercenary entity threw an exception:", (Throwable)e);
    }

    private boolean shouldDespawn() {
        if (this.level() == null || this.level().getGameTime() - this.worldTimeAtSpawn > 48000L || this.colony == null || this.isInvisible()) {
            this.remove(Entity.RemovalReason.DISCARDED);
            return true;
        }
        return false;
    }

    private boolean isInitialized() {
        if (this.worldTimeAtSpawn == 0L) {
            this.worldTimeAtSpawn = this.level().getGameTime();
        }
        return this.level() != null && this.colony != null && this.isAlive() && !this.isInvisible();
    }

    private boolean spawnEvent() {
        if (this.spawnEventTime > 0) {
            --this.spawnEventTime;
        }
        if (!this.doSpawnEvent || this.spawnEventTime == 0) {
            return true;
        }
        if (!this.isLeader) {
            return false;
        }
        if (!this.getNavigation().isDone()) {
            return false;
        }
        BlockPos first = this.soldiers.get(0).blockPosition().offset(0, 0, 1);
        BlockPos last = this.soldiers.get(this.soldiers.size() - 1).blockPosition().offset(0, 0, 1);
        this.playSound(MercenarySounds.mercenaryCelebrate, 2.0f, 1.0f);
        if (this.blockPosition().equals((Object)first)) {
            EntityNavigationUtils.walkToPos(this, last, 2, true, 0.5);
        } else {
            EntityNavigationUtils.walkToPos(this, first, 2, true, 0.5);
        }
        return false;
    }

    public void setDoSpawnEvent() {
        this.doSpawnEvent = true;
        this.spawnEventTime = 15;
    }

    public void setLeader(List<EntityMercenary> soldiers) {
        this.soldiers = soldiers;
        this.isLeader = true;
        this.doSpawnEvent = true;
        this.spawnEventTime = 17;
    }

    public IState getState() {
        return this.stateMachine.getState();
    }

    protected void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound(MercenarySounds.mercenaryStep, 0.45f, 1.0f);
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return MercenarySounds.mercenaryHurt;
    }

    protected SoundEvent getDeathSound() {
        return MercenarySounds.mercenaryDie;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return MercenarySounds.mercenarySay;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putLong("time", this.worldTimeAtSpawn);
        compound.putInt("colony", this.colony == null ? 0 : this.colony.getID());
        super.addAdditionalSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.worldTimeAtSpawn = compound.getLong("time");
        if (compound.contains("colony")) {
            this.colonyId = compound.getInt("colony");
            if (this.colonyId != 0) {
                this.setColony(IColonyManager.getInstance().getColonyByWorld(this.colonyId, this.level()));
            }
        }
        super.readAdditionalSaveData(compound);
    }

    public Component getName() {
        return Component.literal((String)ENTITY_NAME);
    }

    @Override
    public void registerWithColony() {
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, ((Attribute)Attributes.ATTACK_DAMAGE.value()).getDefaultValue()).add(Attributes.FOLLOW_RANGE, 100.0);
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public void setColony(IColony colony) {
        if (colony != null) {
            this.colony = colony;
            this.registerWithColony();
        }
    }

    @Override
    public boolean hurt(DamageSource source, float damage) {
        if (source.getEntity() instanceof LivingEntity) {
            this.setTarget((LivingEntity)source.getEntity());
        }
        return super.hurt(source, damage);
    }

    protected void doPush(Entity entityIn) {
        if (this.slapTimer == 0 && entityIn instanceof Player) {
            this.slapTimer = 100;
            entityIn.hurt(entityIn.level().damageSources().source(DamageSourceKeys.SLAP, (Entity)this), 1.0f);
            this.swing(InteractionHand.OFF_HAND);
        }
        if (this.slapTimer == 0 && entityIn instanceof EntityCitizen && this.colony != null && ((EntityCitizen)entityIn).isActive()) {
            this.slapTimer = 100;
            IItemHandler handler = ((EntityCitizen)entityIn).getItemHandlerCitizen();
            ItemStack stack = handler.extractItem(this.rand.nextInt(handler.getSlots()), 5, false);
            if (!ItemStackUtils.isEmpty(stack)) {
                this.swing(InteractionHand.OFF_HAND);
                MessageUtils.format("com.minecolonies.coremod.mercenary.mercenarystealcitizen", entityIn.getName().getString(), stack.getHoverName().getString()).sendTo(this.colony).forAllPlayers();
            }
        }
    }

    public GeneralEntityWalkToProxy getProxy() {
        if (this.proxy == null) {
            this.proxy = new GeneralEntityWalkToProxy((Mob)this);
        }
        return this.proxy;
    }

    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.newNavigator == null) {
            this.newNavigator = new MinecoloniesAdvancedPathNavigate((Mob)this, this.level());
            this.navigation = this.newNavigator;
            this.newNavigator.setCanFloat(true);
            this.newNavigator.getNodeEvaluator().setCanOpenDoors(true);
        }
        return this.newNavigator;
    }

    public void aiStep() {
        if (this.level() != null && !this.level().isClientSide) {
            this.stateMachine.tick();
        }
        if (this.slapTimer > 0) {
            --this.slapTimer;
        }
        this.updateSwingTime();
        super.aiStep();
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    public static void spawnMercenariesInColony(@NotNull IColony colony) {
        Level world = colony.getWorld();
        if (colony.getMercenaryUseTime() != 0L && world.getGameTime() - colony.getMercenaryUseTime() < 48000L) {
            return;
        }
        colony.usedMercenaries();
        int amountOfMercenaries = colony.getCitizenManager().getCurrentCitizenCount();
        amountOfMercenaries /= 10;
        BlockPos spawn = EntityMercenary.findMercenarySpawnPos(colony, amountOfMercenaries += 3);
        ArrayList<EntityMercenary> soldiers = new ArrayList<EntityMercenary>();
        for (int i = 0; i < amountOfMercenaries; ++i) {
            EntityMercenary merc = (EntityMercenary)ModEntities.MERCENARY.create(world);
            merc.setColony(colony);
            merc.setPos(spawn.getX() + i, spawn.getY(), spawn.getZ());
            merc.setDoSpawnEvent();
            soldiers.add(merc);
            world.addFreshEntity((Entity)merc);
        }
        EntityMercenary merc = (EntityMercenary)ModEntities.MERCENARY.create(world);
        merc.setColony(colony);
        merc.setPos(spawn.getX(), spawn.getY(), spawn.getZ() + 1);
        merc.setLeader(soldiers);
        world.addFreshEntity((Entity)merc);
    }

    private static BlockPos findMercenarySpawnPos(IColony colony, int amountOfMercenaries) {
        Tuple<BlockPos, BlockPos> buildingArea = colony.getBuildingManager().getTownHall().getCorners();
        BlockPos spawn = new BlockPos((((BlockPos)buildingArea.getB()).getX() + ((BlockPos)buildingArea.getA()).getX()) / 2, 0, ((BlockPos)buildingArea.getA()).getZ());
        int height = colony.getWorld().getHeight(Heightmap.Types.WORLD_SURFACE, spawn.getX(), spawn.getZ());
        if (height > ((BlockPos)buildingArea.getB()).getY()) {
            height = ((BlockPos)buildingArea.getA()).getY() + 1;
        }
        spawn = spawn.offset(0, height, 0);
        for (int i = -3; i < 4; ++i) {
            if (!EntityMercenary.isValidSpawnForMercenaries((LevelAccessor)colony.getWorld(), spawn.offset(0, 0, i), amountOfMercenaries)) continue;
            spawn = spawn.offset(0, 0, i);
            break;
        }
        return spawn;
    }

    private static boolean isValidSpawnForMercenaries(LevelAccessor world, BlockPos spawn, int amountOfMercenaries) {
        for (int i = 0; i < amountOfMercenaries; ++i) {
            if (world.isEmptyBlock(spawn.above().offset(i, 0, 0)) && world.isEmptyBlock(spawn.above().offset(i, 0, 1))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getTeamId() {
        return this.colonyId;
    }
}

