/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenFoodHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenHappinessHandler;
import com.minecolonies.api.entity.citizen.happiness.DynamicHappinessSupplier;
import com.minecolonies.api.entity.citizen.happiness.HappinessRegistry;
import com.minecolonies.api.entity.citizen.happiness.IHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.IHappinessSupplierWrapper;
import com.minecolonies.api.entity.citizen.happiness.ITimeBasedHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.StaticHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.TimeBasedHappinessModifier;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.HappinessConstants;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class CitizenHappinessHandler
implements ICitizenHappinessHandler {
    public Map<String, IHappinessModifier> happinessFactors = new HashMap<String, IHappinessModifier>();
    private double cachedHappiness = -1.0;

    public CitizenHappinessHandler(ICitizenData data) {
        this.addModifier(new StaticHappinessModifier("school", 1.0, new DynamicHappinessSupplier(HappinessRegistry.SCHOOL_FUNCTION)));
        this.addModifier(new StaticHappinessModifier("security", 4.0, new DynamicHappinessSupplier(HappinessRegistry.SECURITY_FUNCTION)));
        this.addModifier(new StaticHappinessModifier("social", 2.0, new DynamicHappinessSupplier(HappinessRegistry.SOCIAL_FUNCTION)));
        this.addModifier(new StaticHappinessModifier("mysticalsite", 1.0, new DynamicHappinessSupplier(HappinessRegistry.MYSTICAL_SITE_FUNCTION)));
        this.addModifier(new StaticHappinessModifier("food", 3.0, new DynamicHappinessSupplier(HappinessRegistry.FOOD_FUNCTION)));
        this.addModifier(new TimeBasedHappinessModifier("homelessness", 3.0, (IHappinessSupplierWrapper)new DynamicHappinessSupplier(HappinessRegistry.HOUSING_FUNCTION), new Tuple<Integer, Double>(7, 0.75), new Tuple<Integer, Double>(14, 0.5)));
        this.addModifier(new TimeBasedHappinessModifier("unemployment", 2.0, (IHappinessSupplierWrapper)new DynamicHappinessSupplier(HappinessRegistry.UNEMPLOYMENT_FUNCTION), new Tuple<Integer, Double>(7, 0.75), new Tuple<Integer, Double>(14, 0.5)));
        this.addModifier(new TimeBasedHappinessModifier("health", 2.0, (IHappinessSupplierWrapper)new DynamicHappinessSupplier(HappinessRegistry.HEALTH_FUNCTION), new Tuple<Integer, Double>(7, 0.5), new Tuple<Integer, Double>(14, 0.1)));
        this.addModifier(new TimeBasedHappinessModifier("idleatjob", 1.0, (IHappinessSupplierWrapper)new DynamicHappinessSupplier(HappinessRegistry.IDLEATJOB_FUNCTION), new Tuple<Integer, Double>(7, 0.5), new Tuple<Integer, Double>(14, 0.1)));
        this.addModifier(new TimeBasedHappinessModifier("slepttonight", 1.5, (IHappinessSupplierWrapper)new DynamicHappinessSupplier(HappinessRegistry.SLEPTTONIGHT_FUNCTION), (modifier, d) -> true, new Tuple<Integer, Double>(0, 2.0), new Tuple<Integer, Double>(2, 1.6), new Tuple<Integer, Double>(3, 1.0)));
    }

    public CitizenHappinessHandler() {
    }

    @Override
    public void addModifier(IHappinessModifier modifier) {
        this.happinessFactors.put(modifier.getId(), modifier);
        this.cachedHappiness = -1.0;
    }

    @Override
    public void resetModifier(String name) {
        IHappinessModifier modifier = this.happinessFactors.get(name);
        if (modifier instanceof ITimeBasedHappinessModifier) {
            ITimeBasedHappinessModifier timeBasedHappinessModifier = (ITimeBasedHappinessModifier)modifier;
            timeBasedHappinessModifier.reset();
            this.cachedHappiness = -1.0;
        }
    }

    @Override
    public IHappinessModifier getModifier(String name) {
        return this.happinessFactors.get(name);
    }

    @Override
    public void processDailyHappiness(ICitizenData citizenData) {
        for (IHappinessModifier happinessModifier : this.happinessFactors.values()) {
            if (happinessModifier instanceof ITimeBasedHappinessModifier) {
                ITimeBasedHappinessModifier timeBasedHappinessModifier = (ITimeBasedHappinessModifier)happinessModifier;
                timeBasedHappinessModifier.dayEnd(citizenData);
            }
            if (InteractionValidatorRegistry.hasValidator(Component.translatableEscape((String)("com.minecolonies.coremod.entity.citizen.no." + happinessModifier.getId()), (Object[])new Object[0]))) {
                citizenData.triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)("com.minecolonies.coremod.entity.citizen.no." + happinessModifier.getId()), (Object[])new Object[0]), ChatPriority.CHITCHAT));
            }
            if (!InteractionValidatorRegistry.hasValidator(Component.translatableEscape((String)("com.minecolonies.coremod.entity.citizen.demands." + happinessModifier.getId()), (Object[])new Object[0]))) continue;
            citizenData.triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)("com.minecolonies.coremod.entity.citizen.demands." + happinessModifier.getId()), (Object[])new Object[0]), ChatPriority.CHITCHAT));
        }
        this.cachedHappiness = -1.0;
    }

    @Override
    public double getHappiness(IColony colony, ICitizenData citizenData) {
        if (this.cachedHappiness == -1.0) {
            double total = 0.0;
            double totalWeight = 0.0;
            for (IHappinessModifier happinessModifier : this.happinessFactors.values()) {
                double factor = happinessModifier.getFactor(citizenData);
                if (factor == 1.0) continue;
                total += factor * happinessModifier.getWeight();
                totalWeight += happinessModifier.getWeight();
            }
            double happinessResult = total / totalWeight * (1.0 + colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.HAPPINESS));
            this.cachedHappiness = Math.min(10.0 * happinessResult, 10.0);
        }
        return this.cachedHappiness;
    }

    @Override
    public void read(@NotNull HolderLookup.Provider provider, CompoundTag compound, boolean persist) {
        if (compound.contains("newhappinesshandler")) {
            ListTag tag = compound.getList("newhappinesshandler", 10);
            for (int i = 0; i < tag.size(); ++i) {
                IHappinessModifier modifier;
                CompoundTag compoundTag = tag.getCompound(i);
                String id = compoundTag.getString("id");
                if (this.happinessFactors.containsKey(id)) {
                    this.happinessFactors.get(id).read(provider, compoundTag, persist);
                    continue;
                }
                if (!HappinessConstants.VALID_HAPPINESS_MODIFIERS.contains(id) || (modifier = HappinessRegistry.loadFrom(provider, compoundTag, persist)) == null) continue;
                this.happinessFactors.put(modifier.getId(), modifier);
            }
        }
    }

    @Override
    public void write(@NotNull HolderLookup.Provider provider, CompoundTag compound, boolean persist) {
        ListTag listTag = new ListTag();
        for (IHappinessModifier happinessModifier : this.happinessFactors.values()) {
            CompoundTag compoundNbt = new CompoundTag();
            happinessModifier.write(provider, compoundNbt, persist);
            listTag.add((Object)compoundNbt);
        }
        compound.put("newhappinesshandler", (Tag)listTag);
    }

    @Override
    public List<String> getModifiers() {
        return new ArrayList<String>(this.happinessFactors.keySet());
    }

    public static double getSocialModifier(IColony colony) {
        double total = colony.getCitizenManager().getCitizens().size();
        double unemployment = 0.0;
        double homelessness = 0.0;
        double sickPeople = 0.0;
        double hungryPeople = 0.0;
        for (ICitizenData citizen : colony.getCitizenManager().getCitizens()) {
            if (!citizen.isChild() && citizen.getJob() == null) {
                unemployment += 1.0;
            }
            if (citizen.getHomeBuilding() == null) {
                homelessness += 1.0;
            }
            if (citizen.getEntity().isPresent() && citizen.getCitizenDiseaseHandler().isSick()) {
                sickPeople += 1.0;
            }
            if (!(citizen.getSaturation() <= 1.0)) continue;
            hungryPeople += 1.0;
        }
        return (total - (unemployment + homelessness + sickPeople + hungryPeople)) / total;
    }

    public static double getGuardFactor(IColony colony) {
        double guards = 1.0;
        double workers = 1.0;
        for (ICitizenData citizen : colony.getCitizenManager().getCitizens()) {
            if (citizen.getJob() instanceof AbstractJobGuard) {
                guards += 1.0;
                continue;
            }
            workers += 1.0;
        }
        return Math.min(guards / (workers * 2.0 / 3.0), 2.0);
    }

    public static double getFoodFactor(ICitizenData citizenData) {
        int homeBuildingLevel = citizenData.getHomeBuilding() == null ? 0 : citizenData.getHomeBuilding().getBuildingLevelEquivalent();
        ICitizenFoodHandler foodHandler = citizenData.getCitizenFoodHandler();
        if (homeBuildingLevel == 0 || !foodHandler.hasFullFoodHistory()) {
            return 1.0;
        }
        ICitizenFoodHandler.CitizenFoodStats happinessStats = foodHandler.getFoodHappinessStats();
        double diversityFactor = Math.min(5.0, (double)happinessStats.diversity() / (double)homeBuildingLevel);
        double qualityFactor = Math.min(5.0, (double)happinessStats.quality() / Math.max(1.0, (double)homeBuildingLevel - 2.0));
        return (diversityFactor + qualityFactor) / 2.0;
    }

    public static double getMysticalSiteFactor(IColony colony) {
        return Math.max(1.0, (double)colony.getBuildingManager().getMysticalSiteMaxBuildingLevel() / 2.0);
    }
}

