/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.citizen;

import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import java.util.Objects;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.damagesource.FallLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CitizenCombatTracker
extends CombatTracker {
    private static final Style INTENTIONAL_GAME_DESIGN_STYLE = Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://bugs.mojang.com/browse/MCPE-28723")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"MCPE-28723")));
    private final EntityCitizen citizen;

    public CitizenCombatTracker(EntityCitizen citizen) {
        super((LivingEntity)citizen);
        this.citizen = citizen;
    }

    @NotNull
    public Component getDeathMessage() {
        ItemStack itemStack;
        Component component;
        IJob<?> job = this.citizen.getCitizenJobHandler().getColonyJob();
        MutableComponent nameComponent = job != null ? Component.translatableEscape((String)"block.blockhuttownhall.messageworkerdesc", (Object[])new Object[]{Component.translatableEscape((String)job.getJobRegistryEntry().getTranslationKey(), (Object[])new Object[0]), this.citizen.getCitizenData().getName()}) : Component.translatable((String)"block.blockhuttownhall.messagecitizendeathdesc", (Object[])new Object[]{this.citizen.getCitizenData().getName()});
        if (this.entries.isEmpty()) {
            return Component.translatableEscape((String)"death.attack.generic", (Object[])new Object[]{nameComponent});
        }
        DamageSource lastSource = ((CombatEntry)this.entries.get(this.entries.size() - 1)).source();
        DeathMessageType messageType = lastSource.type().deathMessageType();
        CombatEntry fallEntry = this.getMostSignificantFall();
        if (messageType == DeathMessageType.FALL_VARIANTS && fallEntry != null) {
            DamageSource fallSource = fallEntry.source();
            Entity lastEntity = lastSource.getEntity();
            if (!fallSource.is(DamageTypeTags.IS_FALL) && !fallSource.is(DamageTypeTags.ALWAYS_MOST_SIGNIFICANT_FALL)) {
                Component lastMessage;
                Entity fallEntity = fallSource.getEntity();
                Component fallMessage = fallEntity == null ? null : fallEntity.getDisplayName();
                Component component2 = lastMessage = lastEntity == null ? null : lastEntity.getDisplayName();
                if (fallMessage != null && !fallMessage.equals((Object)lastMessage)) {
                    ItemStack itemStack2;
                    if (fallEntity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)fallEntity;
                        itemStack2 = living.getMainHandItem();
                    } else {
                        itemStack2 = ItemStack.EMPTY;
                    }
                    ItemStack stack = itemStack2;
                    return !stack.isEmpty() && stack.has(DataComponents.CUSTOM_NAME) ? Component.translatableEscape((String)"death.fell.assist.item", (Object[])new Object[]{nameComponent, fallMessage, stack.getDisplayName()}) : Component.translatableEscape((String)"death.fell.assist", (Object[])new Object[]{nameComponent, fallMessage});
                }
                if (lastMessage != null) {
                    ItemStack itemStack3;
                    if (lastEntity instanceof LivingEntity) {
                        LivingEntity livingentity = (LivingEntity)lastEntity;
                        itemStack3 = livingentity.getMainHandItem();
                    } else {
                        itemStack3 = ItemStack.EMPTY;
                    }
                    ItemStack stack = itemStack3;
                    return !stack.isEmpty() && stack.has(DataComponents.CUSTOM_NAME) ? Component.translatableEscape((String)"death.fell.finish.item", (Object[])new Object[]{nameComponent, lastMessage, stack.getDisplayName()}) : Component.translatableEscape((String)"death.fell.finish", (Object[])new Object[]{nameComponent, lastMessage});
                }
                return Component.translatableEscape((String)"death.fell.killer", (Object[])new Object[]{nameComponent});
            }
            return Component.translatableEscape((String)Objects.requireNonNullElse(fallEntry.fallLocation(), FallLocation.GENERIC).languageKey(), (Object[])new Object[]{nameComponent});
        }
        if (messageType == DeathMessageType.INTENTIONAL_GAME_DESIGN) {
            String s = "death.attack." + lastSource.getMsgId();
            return Component.translatableEscape((String)(s + ".message"), (Object[])new Object[]{nameComponent, ComponentUtils.wrapInSquareBrackets((Component)Component.translatableEscape((String)(s + ".link"), (Object[])new Object[0])).withStyle(INTENTIONAL_GAME_DESIGN_STYLE)});
        }
        String s = "death.attack." + lastSource.type().msgId();
        Entity entity = lastSource.getEntity();
        Entity directEntity = lastSource.getDirectEntity();
        if (directEntity == null && entity == null) {
            LivingEntity living = this.citizen.getKillCredit();
            return living != null ? Component.translatableEscape((String)(s + ".player"), (Object[])new Object[]{nameComponent, living.getDisplayName()}) : Component.translatableEscape((String)s, (Object[])new Object[]{nameComponent});
        }
        Component component3 = component = entity == null ? directEntity.getDisplayName() : entity.getDisplayName();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            itemStack = living.getMainHandItem();
        } else {
            itemStack = ItemStack.EMPTY;
        }
        ItemStack stack = itemStack;
        return !stack.isEmpty() && stack.has(DataComponents.CUSTOM_NAME) ? Component.translatableEscape((String)(s + ".item"), (Object[])new Object[]{nameComponent, component, stack.getDisplayName()}) : Component.translatableEscape((String)s, (Object[])new Object[]{nameComponent, component});
    }
}

