/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.util;

import net.minecraft.nbt.CompoundTag;

public class Patient {
    private final int id;
    private PatientState state = PatientState.NEW;

    public Patient(int id) {
        this.id = id;
    }

    public Patient(CompoundTag patientCompound) {
        this.id = patientCompound.getInt("id");
        this.state = PatientState.values()[patientCompound.getInt("status")];
    }

    public int getId() {
        return this.id;
    }

    public PatientState getState() {
        return this.state;
    }

    public void setState(PatientState state) {
        this.state = state;
    }

    public void write(CompoundTag compoundNBT) {
        compoundNBT.putInt("id", this.id);
        compoundNBT.putInt("status", this.state.ordinal());
    }

    public static enum PatientState {
        NEW,
        REQUESTED,
        TREATED;

    }
}

