/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.util;

import com.ldtteam.structurize.api.RotationMirror;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.core.entity.ai.workers.util.MineNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinerLevel {
    private static final String TAG_DEPTH = "Depth";
    private static final String TAG_NODES = "Nodes";
    private static final String TAG_LADDERX = "LadderX";
    private static final String TAG_LADDERZ = "LadderZ";
    private static final String TAG_OPEN_NODES = "OpenNodes";
    private static final String TAG_LEVEL_SIGN = "LevelSign";
    private static final Random rand = new Random();
    private static final int RANDOM_TYPES = 4;
    private static final int MINIMUM_NODES_FOR_RANDOM = 10;
    @NotNull
    private final Map<Vec2i, MineNode> nodes = new HashMap<Vec2i, MineNode>();
    @NotNull
    private final Queue<MineNode> openNodes = new ArrayDeque<MineNode>(11);
    private final int depth;
    private final MineNode ladderNode;
    @Nullable
    private BlockPos levelSign;
    private static final int BUILT_NODES_OFFSET = -2;

    public MinerLevel(@NotNull BuildingMiner buildingMiner, int depth, BlockPos levelSign) {
        this.depth = depth;
        this.levelSign = levelSign;
        int cobbleX = buildingMiner.getCobbleLocation().getX();
        int cobbleZ = buildingMiner.getCobbleLocation().getZ();
        BlockPos vector = buildingMiner.getLadderLocation().subtract((Vec3i)buildingMiner.getCobbleLocation());
        @NotNull Vec2i cobbleCenter = new Vec2i(cobbleX - vector.getX() * 3, cobbleZ - vector.getZ() * 3);
        @NotNull Vec2i ladderCenter = new Vec2i(cobbleX + vector.getX() * 4, cobbleZ + vector.getZ() * 4);
        @NotNull MineNode cobbleNode = new MineNode(cobbleCenter.getX(), cobbleCenter.getZ(), ladderCenter);
        cobbleNode.setStyle(MineNode.NodeType.LADDER_BACK);
        cobbleNode.setStatus(MineNode.NodeStatus.COMPLETED);
        this.nodes.put(cobbleCenter, cobbleNode);
        this.ladderNode = new MineNode(ladderCenter.getX(), ladderCenter.getZ(), null);
        this.ladderNode.setStyle(MineNode.NodeType.SHAFT);
        this.ladderNode.setStatus(MineNode.NodeStatus.COMPLETED);
        this.nodes.put(ladderCenter, this.ladderNode);
        ArrayList<Vec2i> nodeCenterList = new ArrayList<Vec2i>(4);
        nodeCenterList.add(this.ladderNode.getNorthNodeCenter());
        nodeCenterList.add(this.ladderNode.getSouthNodeCenter());
        nodeCenterList.add(this.ladderNode.getEastNodeCenter());
        nodeCenterList.add(this.ladderNode.getWestNodeCenter());
        for (Vec2i pos : nodeCenterList) {
            if (cobbleCenter.equals(pos) || ladderCenter.equals(pos)) continue;
            MineNode tempNode = new MineNode(pos.getX(), pos.getZ(), ladderCenter);
            tempNode.setStyle(MineNode.NodeType.TUNNEL);
            this.nodes.put(pos, tempNode);
            this.openNodes.add(tempNode);
        }
    }

    public MinerLevel(@NotNull CompoundTag compound) {
        int ladderZ;
        int ladderX;
        this.depth = compound.getInt(TAG_DEPTH);
        this.levelSign = compound.contains(TAG_LEVEL_SIGN) ? BlockPosUtil.read(compound, TAG_LEVEL_SIGN) : null;
        ListTag nodeTagList = compound.getList(TAG_NODES, 10);
        for (int i = 0; i < nodeTagList.size(); ++i) {
            @NotNull MineNode node = MineNode.createFromNBT(nodeTagList.getCompound(i));
            this.nodes.put(new Vec2i(node.getX(), node.getZ()), node);
        }
        boolean hasDoubles = compound.contains(TAG_LADDERX);
        if (hasDoubles) {
            ladderX = (int)Math.floor(compound.getDouble(TAG_LADDERX));
            ladderZ = (int)Math.floor(compound.getDouble(TAG_LADDERZ));
        } else {
            ladderX = compound.getInt(TAG_LADDERX);
            ladderZ = compound.getInt(TAG_LADDERZ);
        }
        this.ladderNode = this.nodes.get(new Vec2i(ladderX, ladderZ));
        ListTag openNodeTagList = compound.getList(TAG_OPEN_NODES, 10);
        for (int i = 0; i < openNodeTagList.size(); ++i) {
            @NotNull MineNode node = MineNode.createFromNBT(openNodeTagList.getCompound(i));
            this.openNodes.add(node);
        }
    }

    public MineNode getRandomNode(@Nullable MineNode node) {
        MineNode nextNode = null;
        if (node == null || !this.nodes.containsKey(new Vec2i(node.getX(), node.getZ()))) {
            return this.openNodes.peek();
        }
        if (this.getNumberOfBuiltNodes() > 10 && rand.nextInt(4) > 0) {
            nextNode = node.getRandomNextNode(this, 0);
        }
        return nextNode == null ? this.openNodes.peek() : nextNode;
    }

    public BlockPos getRandomCompletedNode(BuildingMiner buildingMiner) {
        Object[] nodeSet = this.nodes.keySet().toArray();
        MineNode nextNode = this.nodes.get(nodeSet[rand.nextInt(nodeSet.length)]);
        while (nextNode.getStatus() != MineNode.NodeStatus.COMPLETED || nextNode.getStyle() == MineNode.NodeType.LADDER_BACK) {
            nextNode = this.getNode(nextNode.getParent());
        }
        if (nextNode == null || nextNode.getStyle() == MineNode.NodeType.SHAFT) {
            BlockPos vector = buildingMiner.getLadderLocation().subtract((Vec3i)buildingMiner.getCobbleLocation());
            return new BlockPos(this.ladderNode.getX() + 3 * vector.getX(), this.getDepth() + 1, this.ladderNode.getZ() + 3 * vector.getZ());
        }
        return new BlockPos(nextNode.getX(), this.getDepth() + 1, nextNode.getZ());
    }

    public void closeNextNode(RotationMirror rotation, MineNode node, Level world) {
        MineNode tempNode = node == null ? this.openNodes.peek() : node;
        ArrayList<Vec2i> nodeCenterList = new ArrayList<Vec2i>(3);
        if (tempNode == null) {
            return;
        }
        switch (tempNode.getStyle()) {
            case TUNNEL: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, RotationMirror.NONE));
                break;
            }
            case BEND_RIGHT: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, RotationMirror.R270));
                break;
            }
            case BEND_LEFT: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, RotationMirror.R90));
                break;
            }
            case CROSS_THREE_LEFT_RIGHT: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, RotationMirror.R90));
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, RotationMirror.R270));
                break;
            }
            case CROSS_THREE_TOP_LEFT: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, RotationMirror.NONE));
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, RotationMirror.R270));
                break;
            }
            case CROSS_THREE_TOP_RIGHT: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, RotationMirror.NONE));
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, RotationMirror.R90));
                break;
            }
            case CROSSROAD: {
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, RotationMirror.NONE));
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, RotationMirror.R90));
                nodeCenterList.add(MinerLevel.getNextNodePositionFromNodeWithRotation(tempNode, rotation, RotationMirror.R270));
                break;
            }
            case UNDEFINED: {
                Log.getLogger().error("Minecolonies node: " + node.getX() + ":" + node.getZ() + " style undefined creating children, Please tell the mod authors about this");
                return;
            }
            default: {
                return;
            }
        }
        for (Vec2i pos : nodeCenterList) {
            if (this.nodes.containsKey(pos) || !world.getFluidState(new BlockPos(pos.getX(), this.getDepth() + 2, pos.getZ())).isEmpty()) continue;
            MineNode tempNodeToAdd = new MineNode(pos.getX(), pos.getZ(), new Vec2i(tempNode.getX(), tempNode.getZ()));
            tempNodeToAdd.setStyle((MineNode.NodeType)((Object)MineNode.NodeType.SIDE_NODES.get(rand.nextInt(MineNode.NodeType.SIDE_NODES.size()))));
            this.nodes.put(pos, tempNodeToAdd);
            this.openNodes.add(tempNodeToAdd);
        }
        MineNode I = this.nodes.get(new Vec2i(tempNode.getX(), tempNode.getZ()));
        if (!tempNode.equals(I)) {
            Log.getLogger().warn("Minecolonies node: " + node.getX() + ":" + node.getZ() + " not equal to storage during close, Please tell the mod authors about this");
        }
        tempNode.setStatus(MineNode.NodeStatus.COMPLETED);
        this.openNodes.removeIf(tempNode::equals);
    }

    private static Vec2i getNextNodePositionFromNodeWithRotation(MineNode node, RotationMirror rotation, RotationMirror additionalRotation) {
        switch (rotation.rotate(additionalRotation.rotation()).rotation()) {
            case CLOCKWISE_90: {
                return node.getSouthNodeCenter();
            }
            case CLOCKWISE_180: {
                return node.getWestNodeCenter();
            }
            case COUNTERCLOCKWISE_90: {
                return node.getNorthNodeCenter();
            }
        }
        return node.getEastNodeCenter();
    }

    @NotNull
    public String toString() {
        return "Level{depth=" + this.depth + ", nodes=" + String.valueOf(this.nodes) + ", ladderNode=" + String.valueOf(this.ladderNode) + "}";
    }

    public void write(@NotNull CompoundTag compound) {
        compound.putInt(TAG_DEPTH, this.depth);
        if (this.levelSign != null) {
            BlockPosUtil.write(compound, TAG_LEVEL_SIGN, this.levelSign);
        }
        @NotNull ListTag nodeTagList = new ListTag();
        for (MineNode node : this.nodes.values()) {
            @NotNull CompoundTag nodeCompound = new CompoundTag();
            node.write(nodeCompound);
            nodeTagList.add((Object)nodeCompound);
        }
        compound.put(TAG_NODES, (Tag)nodeTagList);
        compound.putInt(TAG_LADDERX, this.ladderNode.getX());
        compound.putInt(TAG_LADDERZ, this.ladderNode.getZ());
        @NotNull ListTag openNodeTagList = new ListTag();
        for (MineNode node : this.openNodes) {
            @NotNull CompoundTag nodeCompound = new CompoundTag();
            node.write(nodeCompound);
            openNodeTagList.add((Object)nodeCompound);
        }
        compound.put(TAG_OPEN_NODES, (Tag)openNodeTagList);
    }

    @NotNull
    public Map<Vec2i, MineNode> getNodes() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public int getNumberOfBuiltNodes() {
        return this.nodes.size() - this.openNodes.size() + -2;
    }

    public int getDepth() {
        return this.depth;
    }

    @NotNull
    public MineNode getLadderNode() {
        return this.ladderNode;
    }

    public MineNode getNode(Vec2i key) {
        return this.nodes.get(key);
    }

    public MineNode getOpenNode(Vec2i key) {
        return this.nodes.get(key);
    }

    public BlockPos getLevelSign() {
        return this.levelSign;
    }
}

