/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production.herders;

import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingShepherd;
import com.minecolonies.core.colony.jobs.JobShepherd;
import com.minecolonies.core.entity.ai.workers.production.herders.AbstractEntityAIHerder;
import com.minecolonies.core.network.messages.client.LocalizedParticleEffectMessage;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkShepherd
extends AbstractEntityAIHerder<JobShepherd, BuildingShepherd> {
    private static final int HUNDRED_PERCENT_CHANCE = 100;

    public EntityAIWorkShepherd(@NotNull JobShepherd job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.SHEPHERD_SHEAR, this::shearSheep, 20));
    }

    @Override
    @NotNull
    public List<EquipmentTypeEntry> getExtraToolsNeeded() {
        List<EquipmentTypeEntry> toolsNeeded = super.getExtraToolsNeeded();
        if (((BuildingShepherd)this.building).getSetting(BuildingShepherd.SHEARING).getValue().booleanValue()) {
            toolsNeeded.add((EquipmentTypeEntry)ModEquipmentTypes.shears.get());
        }
        return toolsNeeded;
    }

    @Override
    public Class<BuildingShepherd> getExpectedBuildingClass() {
        return BuildingShepherd.class;
    }

    @Override
    public IAIState decideWhatToDo() {
        IAIState result = super.decideWhatToDo();
        Sheep shearingSheep = this.findShearableSheep();
        if (((BuildingShepherd)this.building).getSetting(BuildingShepherd.SHEARING).getValue().booleanValue() && result.equals(AIWorkerState.START_WORKING) && shearingSheep != null) {
            return AIWorkerState.SHEPHERD_SHEAR;
        }
        this.worker.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        return result;
    }

    @Override
    public double getButcheringAttackDamage() {
        return Math.max(1.0, (double)this.getSecondarySkillLevel() / 10.0);
    }

    @Nullable
    private Sheep findShearableSheep() {
        return this.searchForAnimals(a -> {
            Sheep sheepie;
            return a instanceof Sheep && !(sheepie = (Sheep)a).isSheared() && !sheepie.isBaby();
        }).stream().map(a -> (Sheep)a).findAny().orElse(null);
    }

    private IAIState shearSheep() {
        Sheep sheep = this.findShearableSheep();
        if (sheep == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipTool(InteractionHand.MAIN_HAND, (EquipmentTypeEntry)ModEquipmentTypes.shears.get())) {
            return AIWorkerState.PREPARING;
        }
        if (this.worker.getMainHandItem() != null) {
            if (this.walkingToAnimal((Animal)sheep)) {
                return this.getState();
            }
            int enchantmentLevel = this.worker.getMainHandItem().getEnchantmentLevel(Utils.getRegistryValue(Enchantments.FORTUNE, (Level)this.world));
            enchantmentLevel = (int)((double)enchantmentLevel * Math.max(1.0, (double)this.getPrimarySkillLevel() / 5.0));
            this.worker.swing(InteractionHand.MAIN_HAND);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            if (!this.world.isClientSide) {
                sheep.setSheared(true);
                int qty = 1 + this.worker.getRandom().nextInt(enchantmentLevel + 1);
                for (int j = 0; j < qty; ++j) {
                    items.add(new ItemStack((ItemLike)Sheep.ITEM_BY_DYE.get(sheep.getColor())));
                }
            }
            sheep.playSound(SoundEvents.SHEEP_SHEAR, 1.0f, 1.0f);
            new LocalizedParticleEffectMessage(new ItemStack((ItemLike)Sheep.ITEM_BY_DYE.get(sheep.getColor())), sheep.getOnPos().above()).sendToTrackingEntity((Entity)this.worker);
            this.dyeSheepChance(sheep);
            CitizenItemUtils.damageItemInHand(this.worker, InteractionHand.MAIN_HAND, 1);
            this.worker.getCitizenExperienceHandler().addExperience(0.5);
            this.incrementActionsDoneAndDecSaturation();
            for (ItemStack item : items) {
                ((BuildingShepherd)this.building).getModule(BuildingModules.STATS_MODULE).incrementBy("item_obtained;" + item.getItem().getDescriptionId(), item.getCount());
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(item, (IItemHandler)this.worker.getInventoryCitizen());
            }
        }
        return AIWorkerState.DECIDE;
    }

    private void dyeSheepChance(Sheep sheep) {
        if (this.building != null && ((BuildingShepherd)this.building).getSetting(BuildingShepherd.DYEING).getValue().booleanValue()) {
            int chanceToDye = ((BuildingShepherd)this.building).getBuildingLevel();
            int rand = this.worker.getRandom().nextInt(100);
            if (rand <= chanceToDye) {
                DyeColor[] colors = DyeColor.values();
                int dyeIndex = this.worker.getRandom().nextInt(colors.length);
                sheep.setColor(colors[dyeIndex]);
            }
        }
    }
}

