/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.guard.training;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingArchery;
import com.minecolonies.core.colony.jobs.JobArcherTraining;
import com.minecolonies.core.entity.ai.workers.guard.training.AbstractEntityAITraining;
import com.minecolonies.core.util.WorkerUtil;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIArcherTraining
extends AbstractEntityAITraining<JobArcherTraining, BuildingArchery> {
    private static final int XP_PER_SUCCESSFUL_SHOT = 1;
    private static final int BUILDING_LEVEL_TARGET_MULTIPLIER = 5;
    private static final double MIN_DISTANCE_FOR_SUCCESS = 2.0;
    private static final int RANGED_ATTACK_DELAY_BASE = 10;
    private static final double XP_BASE_RATE = 0.2;
    private static final int CHECK_SHOT_DELAY = 60;
    private static final VisibleCitizenStatus ARCHER_TRAIN = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/archer_uni.png"), "com.minecolonies.gui.visiblestatus.archer_uni");
    private BlockPos currentShootingTarget;
    private int targetCounter;
    private Arrow arrowInProgress;

    public EntityAIArcherTraining(@NotNull JobArcherTraining job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.COMBAT_TRAINING, this::findShootingStandPosition, 5), new AITarget<Object>(AIWorkerState.ARCHER_SELECT_TARGET, this::selectTarget, 5), new AITarget<Object>(AIWorkerState.ARCHER_CHECK_SHOT, this::checkShot, 60), new AITarget<Object>(AIWorkerState.ARCHER_SHOOT, this::shoot, 5));
    }

    private IAIState selectTarget() {
        BuildingArchery archeryBuilding = (BuildingArchery)this.building;
        if (this.targetCounter >= archeryBuilding.getBuildingLevel() * 5) {
            this.targetCounter = 0;
            return AIWorkerState.DECIDE;
        }
        BlockPos targetPos = archeryBuilding.getRandomShootingTarget(this.worker.getRandom());
        if (targetPos == null || !WorldUtil.isBlockLoaded((LevelAccessor)this.world, targetPos) || !this.world.clip(new ClipContext(new Vec3(this.worker.getX(), this.worker.getEyeY(), this.worker.getZ()), new Vec3((double)targetPos.getX() + 0.5, (double)targetPos.getY() + 0.5, (double)targetPos.getZ() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.worker)).getBlockPos().equals((Object)targetPos)) {
            return AIWorkerState.DECIDE;
        }
        this.worker.getCitizenData().setVisibleStatus(ARCHER_TRAIN);
        this.currentShootingTarget = targetPos;
        ++this.targetCounter;
        return AIWorkerState.ARCHER_SHOOT;
    }

    private IAIState findShootingStandPosition() {
        BuildingArchery archeryBuilding = (BuildingArchery)this.building;
        BlockPos shootingPos = archeryBuilding.getRandomShootingStandPosition(this.worker.getRandom());
        if (shootingPos == null) {
            return AIWorkerState.DECIDE;
        }
        this.stateAfterPathing = AIWorkerState.ARCHER_SELECT_TARGET;
        this.currentPathingTarget = shootingPos;
        return AIWorkerState.GO_TO_TARGET;
    }

    protected IAIState shoot() {
        Arrow arrow;
        if (this.currentShootingTarget == null || !this.isSetup()) {
            this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
            return AIWorkerState.START_WORKING;
        }
        if (this.worker.isUsingItem()) {
            WorkerUtil.faceBlock(this.currentShootingTarget, this.worker);
            this.worker.swing(InteractionHand.MAIN_HAND);
            arrow = (Arrow)ModEntities.MC_NORMAL_ARROW.create((Level)this.world);
            arrow.setBaseDamage(0.0);
            arrow.setOwner((Entity)this.worker);
            arrow.setPos(this.worker.getX(), this.worker.getY() + 1.0, this.worker.getZ());
            double xVector = (double)this.currentShootingTarget.getX() - this.worker.getX();
            double yVector = (double)this.currentShootingTarget.getY() - arrow.getY();
            double zVector = (double)this.currentShootingTarget.getZ() - this.worker.getZ();
            double distance = Mth.sqrt((float)((float)(xVector * xVector + zVector * zVector)));
            double chance = 15.0 / ((double)this.getPrimarySkillLevel() / 2.0 + 1.0);
            arrow.shoot(xVector, yVector + distance * (double)0.2f, zVector, 1.6f, (float)chance);
            this.worker.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.getRandom()));
            this.worker.level().addFreshEntity((Entity)arrow);
            double xDiff = (double)this.currentShootingTarget.getX() - this.worker.getX();
            double zDiff = (double)this.currentShootingTarget.getZ() - this.worker.getZ();
            double goToX = xDiff > 0.0 ? 0.01 : -0.01;
            double goToZ = zDiff > 0.0 ? 0.01 : -0.01;
            this.worker.move(MoverType.SELF, new Vec3(goToX, 0.0, goToZ));
            if (this.worker.getRandom().nextBoolean()) {
                CitizenItemUtils.damageItemInHand(this.worker, InteractionHand.MAIN_HAND, 1);
            }
        } else {
            this.reduceAttackDelay();
            if (this.currentAttackDelay <= 0) {
                this.worker.startUsingItem(InteractionHand.MAIN_HAND);
            }
            return AIWorkerState.ARCHER_SHOOT;
        }
        this.worker.stopUsingItem();
        this.incrementActionsDoneAndDecSaturation();
        this.arrowInProgress = arrow;
        this.currentAttackDelay = 10;
        return AIWorkerState.ARCHER_CHECK_SHOT;
    }

    private IAIState checkShot() {
        int priorPrimaryLevel = this.getPrimarySkillLevel();
        int priorSecondaryLevel = this.getSecondarySkillLevel();
        Vec3 vec3 = new Vec3((double)this.currentShootingTarget.getX(), (double)this.currentShootingTarget.getY(), (double)this.currentShootingTarget.getZ());
        if (this.arrowInProgress.distanceToSqr(vec3) < 2.0) {
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            StatsUtil.trackStat(this.building, "arrows_hit", 1);
        } else {
            this.worker.getCitizenExperienceHandler().addExperience(0.2);
        }
        StatsUtil.trackStat(this.building, "arrows_fired", 1);
        if (this.getPrimarySkillLevel() - priorPrimaryLevel > 0) {
            StatsUtil.trackStatByName((IBuilding)this.building, "levels_gained", this.getModuleForJob().getPrimarySkill().name(), this.getPrimarySkillLevel() - priorPrimaryLevel);
        }
        if (this.getSecondarySkillLevel() - priorSecondaryLevel > 0) {
            StatsUtil.trackStatByName((IBuilding)this.building, "levels_gained", this.getModuleForJob().getSecondarySkill().name(), this.getSecondarySkillLevel() - priorSecondaryLevel);
        }
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        return AIWorkerState.ARCHER_SELECT_TARGET;
    }

    @Override
    protected boolean isSetup() {
        if (this.checkForToolOrWeapon((EquipmentTypeEntry)ModEquipmentTypes.bow.get())) {
            this.setDelay(60);
            return false;
        }
        int bowSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingEquipment((IItemHandler)this.getInventory(), (EquipmentTypeEntry)ModEquipmentTypes.bow.get(), 0, ((BuildingArchery)this.building).getMaxEquipmentLevel());
        CitizenItemUtils.setHeldItem(this.worker, InteractionHand.MAIN_HAND, bowSlot);
        return true;
    }

    @Override
    public Class<BuildingArchery> getExpectedBuildingClass() {
        return BuildingArchery.class;
    }
}

