/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.minimal;

import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.statemachine.states.CitizenAIState;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.network.messages.client.SleepingParticleMessage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class EntityAISleep
implements IStateAI {
    private static final int TICK_INTERVAL = 30;
    private static final int CHANCE = 33;
    private static final int MAX_BED_TICKS = 10;
    private final EntityCitizen citizen;
    private BlockPos usedBed = null;
    private int bedTicks = 0;

    public EntityAISleep(EntityCitizen citizen) {
        this.citizen = citizen;
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(CitizenAIState.SLEEP, () -> true, this::checkSleep, 20));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(SleepState.WALKING_HOME, () -> true, this::walkHome, 30));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(SleepState.FIND_BED, this::findBed, () -> SleepState.SLEEPING, 30));
        citizen.getCitizenAI().addTransition(new TickingTransition<IState>(SleepState.SLEEPING, () -> true, this::sleep, 30));
    }

    private IState checkSleep() {
        this.initAI();
        return SleepState.WALKING_HOME;
    }

    private IState walkHome() {
        BlockPos homePosition;
        IBuilding homeBuilding = this.citizen.getCitizenData().getHomeBuilding();
        if (homeBuilding == null ? (homePosition = this.citizen.getCitizenData().getHomePosition()).distSqr((Vec3i)BlockPos.containing((double)Math.floor(this.citizen.getX()), (double)this.citizen.getY(), (double)Math.floor(this.citizen.getZ()))) <= 16.0 : homeBuilding.isInBuilding(this.citizen.blockPosition())) {
            return SleepState.FIND_BED;
        }
        this.citizen.getCitizenData().setVisibleStatus(VisibleCitizenStatus.SLEEP);
        this.goHome();
        return SleepState.WALKING_HOME;
    }

    private boolean findBed() {
        if (!this.citizen.getCitizenSleepHandler().isAsleep() && this.bedTicks < 10) {
            this.findBedAndTryToSleep();
            return false;
        }
        return true;
    }

    public void initAI() {
        this.usedBed = null;
        this.bedTicks = 0;
    }

    private void findBedAndTryToSleep() {
        IBuilding iBuilding;
        IColony colony = this.citizen.getCitizenColonyHandler().getColonyOrRegister();
        if (colony != null && (iBuilding = this.citizen.getCitizenData().getHomeBuilding()) instanceof AbstractBuilding) {
            AbstractBuilding hut = (AbstractBuilding)iBuilding;
            BlockPos homePos = this.citizen.getCitizenData().getHomePosition();
            if (this.usedBed == null || this.usedBed == homePos) {
                List<BlockPos> bedList = hut.getModule(BuildingModules.BED).getRegisteredBlocks();
                int index = ((AbstractAssignedCitizenModule)hut.getFirstModuleOccurance(AbstractAssignedCitizenModule.class)).getAssignedCitizen().indexOf(this.citizen.getCitizenData());
                if (index >= 0 && index < bedList.size()) {
                    BlockPos pos = bedList.get(index);
                    if (WorldUtil.isEntityBlockLoaded((LevelAccessor)this.citizen.level(), pos)) {
                        Level world = this.citizen.level();
                        BlockState state = world.getBlockState(pos);
                        BlockState above = world.getBlockState(pos.above());
                        if (!state.is(BlockTags.BEDS)) {
                            hut.getModule(BuildingModules.BED).removeBed(pos);
                            return;
                        }
                        if (((BedPart)state.getValue((Property)BedBlock.PART)).equals((Object)BedPart.HEAD) && (above.is(BlockTags.BEDS) || above.getBlock() instanceof PanelBlock || above.getBlock() instanceof TrapDoorBlock || !above.isSolid())) {
                            this.usedBed = pos;
                            return;
                        }
                    }
                }
                this.usedBed = homePos;
            }
            if (EntityNavigationUtils.walkToPosInBuilding(this.citizen, this.usedBed, this.citizen.getCitizenData().getHomeBuilding(), 12)) {
                ++this.bedTicks;
                BlockState state = this.citizen.level().getBlockState(this.usedBed);
                if (state.isBed((BlockGetter)this.citizen.level(), this.usedBed, (LivingEntity)this.citizen) && ((Boolean)state.getValue((Property)BedBlock.OCCUPIED)).booleanValue() && !this.citizen.level().getEntitiesOfClass(LivingEntity.class, new AABB(this.usedBed), LivingEntity::isSleeping).isEmpty()) {
                    this.usedBed = homePos;
                }
                if (!this.citizen.getCitizenSleepHandler().trySleep(this.usedBed)) {
                    this.citizen.getCitizenData().setBedPos(BlockPos.ZERO);
                    this.usedBed = null;
                }
                this.citizen.getCitizenData().getCitizenHappinessHandler().resetModifier("slepttonight");
            } else {
                this.bedTicks = 0;
            }
        }
    }

    private IState sleep() {
        if (this.usedBed != null) {
            if (this.usedBed.distSqr((Vec3i)this.citizen.blockPosition()) > 9.0) {
                return SleepState.WALKING_HOME;
            }
            this.citizen.setPose(Pose.SLEEPING);
        } else {
            this.findBedAndTryToSleep();
        }
        new SleepingParticleMessage(this.citizen.getX(), this.citizen.getY() + 1.0, this.citizen.getZ()).sendToTrackingEntity((Entity)this.citizen);
        return null;
    }

    private void goHome() {
        IBuilding home = this.citizen.getCitizenData().getHomeBuilding();
        if (home != null) {
            EntityNavigationUtils.walkToBuilding(this.citizen, home);
        } else {
            EntityNavigationUtils.walkToPos(this.citizen, this.citizen.getCitizenData().getHomePosition(), 4, true);
        }
        int chance = this.citizen.getRandom().nextInt(33);
        if (chance <= 1 && this.citizen.getCitizenColonyHandler().getWorkBuilding() != null && this.citizen.getCitizenJobHandler().getColonyJob() != null) {
            SoundUtils.playSoundAtCitizenWith(CompatibilityUtils.getWorldFromCitizen(this.citizen), this.citizen.blockPosition(), EventType.OFF_TO_BED, this.citizen.getCitizenData());
        }
    }

    public static enum SleepState implements IState
    {
        WALKING_HOME,
        FIND_BED,
        SLEEPING;

    }
}

