/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.datalistener.model;

import com.minecolonies.api.crafting.ItemStorage;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record Disease(ResourceLocation id, Component name, int rarity, List<ItemStorage> cureItems) implements WeightedEntry
{
    public static Predicate<ItemStack> hasCureItem(ItemStorage cure) {
        return stack -> Disease.isCureItem(stack, cure);
    }

    public static boolean isCureItem(ItemStack stack, ItemStorage cure) {
        return Objects.equals(new ItemStorage(stack), cure);
    }

    public Component getCureString() {
        MutableComponent cureString = Component.literal((String)"");
        for (int i = 0; i < this.cureItems.size(); ++i) {
            ItemStorage cureStack = this.cureItems.get(i);
            cureString.append(String.valueOf(cureStack.getItemStack().getCount())).append(" ").append(cureStack.getItemStack().getHoverName());
            if (i == this.cureItems.size() - 1) continue;
            cureString.append(" + ");
        }
        return cureString;
    }

    @NotNull
    public Weight getWeight() {
        return Weight.of((int)this.rarity);
    }
}

