/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.eventhooks.citizenEvents;

import com.minecolonies.api.colony.colonyEvents.descriptions.ICitizenEventDescription;
import com.minecolonies.api.util.BlockPosUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCitizenEvent
implements ICitizenEventDescription {
    private BlockPos eventPos;
    private String citizenName;

    public AbstractCitizenEvent() {
    }

    public AbstractCitizenEvent(BlockPos eventPos, String citizenName) {
        this.eventPos = eventPos;
        this.citizenName = citizenName;
    }

    @Override
    public BlockPos getEventPos() {
        return this.eventPos;
    }

    @Override
    public void setEventPos(BlockPos eventPos) {
        this.eventPos = eventPos;
    }

    @Override
    public String getCitizenName() {
        return this.citizenName;
    }

    @Override
    public void setCitizenName(String citizenName) {
        this.citizenName = citizenName;
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        BlockPosUtil.write(compound, "eventPos", this.eventPos);
        compound.putString("citizenName", this.citizenName);
        return compound;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.eventPos = BlockPosUtil.read(compound, "eventPos");
        this.citizenName = compound.getString("citizenName");
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.eventPos);
        buf.writeUtf(this.citizenName);
    }

    @Override
    public void deserialize(RegistryFriendlyByteBuf buf) {
        this.eventPos = buf.readBlockPos();
        this.citizenName = buf.readUtf();
    }

    public String toString() {
        return this.toDisplayString();
    }
}

