/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.IItemStorageFactory;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStorageFactory
implements IItemStorageFactory {
    private static final String TAG_SIZE = "size";
    private static final String TAG_STACK = "stack";
    private static final String TAG_SHOULDIGNORENBT = "ignoreNBT";
    private static final String TAG_SHOULDIGNOREDAMAGE = "ignoreDamage";

    @Override
    @NotNull
    public TypeToken<ItemStorage> getFactoryOutputType() {
        return TypeConstants.ITEMSTORAGE;
    }

    @Override
    @NotNull
    public TypeToken<FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    @NotNull
    public ItemStorage getNewInstance(@NotNull ItemStack stack, int size, boolean ignoreDamage, boolean ignoreNBT) {
        return new ItemStorage(stack, size, ignoreDamage, ignoreNBT);
    }

    @Override
    @NotNull
    public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull ItemStorage storage) {
        CompoundTag compound = new CompoundTag();
        compound.put(TAG_STACK, storage.getItemStack().saveOptional(provider));
        compound.putInt(TAG_SIZE, storage.getAmount());
        compound.putBoolean(TAG_SHOULDIGNOREDAMAGE, storage.ignoreDamageValue());
        compound.putBoolean(TAG_SHOULDIGNORENBT, storage.ignoreNBT());
        return compound;
    }

    @Override
    @NotNull
    public ItemStorage deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
        ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound(TAG_STACK));
        stack.setCount(1);
        int size = nbt.getInt(TAG_SIZE);
        boolean ignoreNBT = nbt.getBoolean(TAG_SHOULDIGNORENBT);
        boolean ignoreDamage = nbt.getBoolean(TAG_SHOULDIGNOREDAMAGE);
        return this.getNewInstance(stack, size, ignoreDamage, ignoreNBT);
    }

    @Override
    public void serialize(IFactoryController controller, ItemStorage input, RegistryFriendlyByteBuf packetBuffer) {
        int writerIndex = packetBuffer.writerIndex();
        try {
            Utils.serializeCodecMess(packetBuffer, input.getItemStack());
        }
        catch (Exception ex) {
            packetBuffer.writerIndex(writerIndex);
            Utils.serializeCodecMess(packetBuffer, ItemStack.EMPTY);
        }
        packetBuffer.writeVarInt(input.getAmount());
        packetBuffer.writeBoolean(input.ignoreDamageValue());
        packetBuffer.writeBoolean(input.ignoreNBT());
    }

    @Override
    public ItemStorage deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
        ItemStack stack = Utils.deserializeCodecMess(buffer);
        int size = buffer.readVarInt();
        boolean ignoreDamage = buffer.readBoolean();
        boolean ignoreNBT = buffer.readBoolean();
        return this.getNewInstance(stack, size, ignoreDamage, ignoreNBT);
    }

    @Override
    public short getSerializationId() {
        return 27;
    }
}

