/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.datalistener.model.StudyItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class BuildingLibrary
extends AbstractBuilding {
    private static final String LIBRARY_HUT_NAME = "library";
    private static final int MAX_BUILDING_LEVEL = 5;
    private final List<BlockPos> bookCases = new ArrayList<BlockPos>();

    public BuildingLibrary(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(StudyItem::isStudyItem, new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LIBRARY_HUT_NAME;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        ListTag furnaceTagList = compound.getList("bookcase", 11);
        for (int i = 0; i < furnaceTagList.size(); ++i) {
            this.bookCases.add(NBTUtils.readBlockPos(furnaceTagList.get(i)));
        }
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        @NotNull ListTag bookcaseTagList = new ListTag();
        for (BlockPos entry : this.bookCases) {
            bookcaseTagList.add((Object)NBTUtils.writeBlockPos(entry));
        }
        compound.put("bookcase", (Tag)bookcaseTagList);
        return compound;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(block, pos, world);
        if (block.defaultBlockState().is(Tags.Blocks.BOOKSHELVES)) {
            this.bookCases.add(pos);
        }
    }

    public BlockPos getRandomBookShelf() {
        if (this.bookCases.isEmpty()) {
            return this.getPosition();
        }
        BlockPos returnPos = this.bookCases.get(MathUtils.RANDOM.nextInt(this.bookCases.size()));
        if (this.colony.getWorld().getBlockState(returnPos).is(Tags.Blocks.BOOKSHELVES)) {
            return returnPos;
        }
        this.bookCases.remove(returnPos);
        return this.getPosition();
    }
}

