/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AnimalHerdingModule;
import com.minecolonies.core.colony.buildings.modules.settings.IntSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.colony.buildings.modules.settings.StringSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BuildingCowboy
extends AbstractBuilding {
    private static final String COWBOY = "cowboy";
    private static final String HUT_NAME = "cowboyhut";
    private static final int MAX_BUILDING_LEVEL = 5;
    public static final ISettingKey<IntSetting> MILKING_AMOUNT = new SettingKey<IntSetting>(IntSetting.class, new ResourceLocation("minecolonies", "milking_amount"));
    public static final ISettingKey<IntSetting> STEWING_AMOUNT = new SettingKey<IntSetting>(IntSetting.class, new ResourceLocation("minecolonies", "stewing_amount"));
    public static final ISettingKey<IntSetting> MILKING_DAYS = new SettingKey<IntSetting>(IntSetting.class, new ResourceLocation("minecolonies", "milking_days"));
    public static final ISettingKey<StringSetting> MILK_ITEM = new SettingKey<StringSetting>(StringSetting.class, new ResourceLocation("minecolonies", "milk_item"));

    public BuildingCowboy(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COWBOY;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (stack.getItem() == Items.WHEAT) {
            return false;
        }
        return super.canEat(stack);
    }

    public ItemStack getMilkInputItem() {
        if (this.getSetting(MILK_ITEM).getValue().equals(ModItems.large_milk_bottle.getDescriptionId())) {
            return ModItems.large_empty_bottle.getDefaultInstance();
        }
        return Items.BUCKET.getDefaultInstance();
    }

    public ItemStack getMilkOutputItem() {
        if (this.getSetting(MILK_ITEM).getValue().equals(ModItems.large_milk_bottle.getDescriptionId())) {
            return ModItems.large_milk_bottle.getDefaultInstance();
        }
        return Items.MILK_BUCKET.getDefaultInstance();
    }

    public static class HerdingModule
    extends AnimalHerdingModule
    implements IBuildingEventsModule,
    IPersistentModule {
        private int currentMilk;
        private int currentStew;
        private int currentMilkDays;

        public HerdingModule() {
            super((JobEntry)ModJobs.cowboy.get(), a -> a instanceof Cow || a instanceof Goat, new ItemStorage(Items.WHEAT, 2));
        }

        @Override
        public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
            Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> requiredItems = super.getRequiredItemsAndAmount();
            int days = Math.max(1, this.getBuilding().getSetting(MILKING_DAYS).getValue());
            int bucketsToKeep = (int)Math.ceil(2.0 * (double)this.getBuilding().getSetting(MILKING_AMOUNT).getValue().intValue() / (double)days);
            int bowlsToKeep = (int)Math.ceil(2.0 * (double)this.getBuilding().getSetting(STEWING_AMOUNT).getValue().intValue() / (double)days);
            if (bucketsToKeep > 0) {
                requiredItems.put(s -> s.is(Items.BUCKET), (Tuple<Integer, Boolean>)new Tuple((Object)bucketsToKeep, (Object)false));
                requiredItems.put(s -> s.is(ModItems.large_empty_bottle), (Tuple<Integer, Boolean>)new Tuple((Object)bucketsToKeep, (Object)true));
            }
            if (bowlsToKeep > 0) {
                requiredItems.put(s -> s.is(Items.BOWL), (Tuple<Integer, Boolean>)new Tuple((Object)bowlsToKeep, (Object)false));
            }
            return requiredItems;
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getRecipesForDisplayPurposesOnly(@NotNull Animal animal) {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getRecipesForDisplayPurposesOnly(animal));
            if (animal instanceof MushroomCow) {
                recipes.add(GenericRecipe.builder().withOutputs(List.of(Items.MUSHROOM_STEW.getDefaultInstance(), Items.SUSPICIOUS_STEW.getDefaultInstance())).withInputs(List.of(List.of(Items.BOWL.getDefaultInstance()))).withRequiredEntity(animal.getType()).build());
            } else if (animal instanceof Cow) {
                recipes.add(GenericRecipe.builder().withOutput((ItemLike)Items.MILK_BUCKET).withInputs(List.of(List.of(Items.BUCKET.getDefaultInstance()))).withRequiredEntity(animal.getType()).build());
                recipes.add(GenericRecipe.builder().withOutput((ItemLike)ModItems.large_milk_bottle).withInputs(List.of(List.of(ModItems.large_empty_bottle.getDefaultInstance()))).withRequiredEntity(animal.getType()).build());
            } else if (animal instanceof Goat) {
                recipes.add(GenericRecipe.builder().withOutput((ItemLike)Items.MILK_BUCKET).withInputs(List.of(List.of(Items.BUCKET.getDefaultInstance()))).withRequiredEntity(animal.getType()).build());
                recipes.add(GenericRecipe.builder().withOutput((ItemLike)ModItems.large_milk_bottle).withInputs(List.of(List.of(ModItems.large_empty_bottle.getDefaultInstance()))).withRequiredEntity(animal.getType()).build());
            }
            return recipes;
        }

        @Override
        public void serializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
            compound.putInt("milkValue", this.currentMilk);
            compound.putInt("stewValue", this.currentStew);
            compound.putInt("milkDays", this.currentMilkDays);
        }

        @Override
        public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
            this.currentMilk = compound.getInt("milkValue");
            this.currentStew = compound.getInt("stewValue");
            this.currentMilkDays = compound.getInt("milkDays");
        }

        @Override
        public void onWakeUp() {
            ++this.currentMilkDays;
            if (this.currentMilkDays >= this.getBuilding().getSetting(MILKING_DAYS).getValue()) {
                this.currentMilk = 0;
                this.currentStew = 0;
                this.currentMilkDays = 0;
            }
        }

        public boolean canTryToMilk() {
            return this.currentMilk < this.getBuilding().getSetting(MILKING_AMOUNT).getValue();
        }

        public boolean canTryToStew() {
            return this.currentStew < this.getBuilding().getSetting(STEWING_AMOUNT).getValue();
        }

        public void onMilked() {
            ++this.currentMilk;
        }

        public void onStewed() {
            ++this.currentStew;
        }
    }
}

