/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingConcreteMixer
extends AbstractBuilding {
    private static final String CONCRETE_MIXER = "concretemixer";
    private static final int WATER_DEPTH_SUPPORT = 5;
    private final Map<Integer, List<BlockPos>> waterPos = new HashMap<Integer, List<BlockPos>>();

    public BuildingConcreteMixer(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.pickaxe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level world) {
        if (!blockState.getFluidState().isEmpty() && (blockState.isAir() || blockState.getBlock() == Blocks.WATER) && blockState.getFluidState().getType() == Fluids.FLOWING_WATER && blockState.getFluidState().getAmount() <= 5) {
            List fluidPos = this.waterPos.getOrDefault(blockState.getFluidState().getAmount(), new ArrayList());
            if (!fluidPos.contains(pos)) {
                fluidPos.add(pos);
            }
            this.waterPos.put(blockState.getFluidState().getAmount(), fluidPos);
        }
        super.registerBlockPosition(blockState, pos, world);
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        @NotNull ListTag waterMap = new ListTag();
        for (Map.Entry<Integer, List<BlockPos>> entry : this.waterPos.entrySet()) {
            CompoundTag waterCompound = new CompoundTag();
            waterCompound.putInt("level", entry.getKey().intValue());
            @NotNull ListTag waterList = new ListTag();
            for (BlockPos pos : entry.getValue()) {
                waterList.add((Object)NBTUtils.writeBlockPos(pos));
            }
            waterCompound.put("Pond", (Tag)waterList);
            waterMap.add((Object)waterCompound);
        }
        compound.put("Pond", (Tag)waterMap);
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        this.waterPos.clear();
        ListTag waterMapList = compound.getList("Pond", 10);
        for (int i = 0; i < waterMapList.size(); ++i) {
            CompoundTag waterCompound = waterMapList.getCompound(i);
            int level = waterCompound.getInt("level");
            ListTag waterTagList = waterCompound.getList("Pond", 11);
            ArrayList<BlockPos> water = new ArrayList<BlockPos>();
            for (int j = 0; j < waterTagList.size(); ++j) {
                BlockPos waterPos = NBTUtils.readBlockPos(waterTagList.get(j));
                if (water.contains(waterPos)) continue;
                water.add(waterPos);
            }
            this.waterPos.put(level, water);
        }
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return CONCRETE_MIXER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public int getMaxConcretePlaced() {
        int size = 0;
        for (List<BlockPos> positions : this.waterPos.values()) {
            size += positions.size();
        }
        return size;
    }

    @Nullable
    public BlockPos getBlockToMine() {
        for (int i = 1; i <= 5; ++i) {
            for (BlockPos pos : this.waterPos.getOrDefault(i, Collections.emptyList())) {
                BlockState state = this.colony.getWorld().getBlockState(pos);
                if (state.isAir() || state.is(Blocks.WATER)) continue;
                return pos;
            }
        }
        return null;
    }

    @Nullable
    public BlockPos getBlockToPlace() {
        for (int i = 1; i <= 5; ++i) {
            for (BlockPos pos : this.waterPos.getOrDefault(i, Collections.emptyList())) {
                BlockState state = this.colony.getWorld().getBlockState(pos);
                if (!state.is(Blocks.WATER)) continue;
                return pos;
            }
        }
        return null;
    }

    public int outputBlockCountInWorld(ItemStack primaryOutput) {
        int count = 0;
        if (primaryOutput.getItem() instanceof BlockItem) {
            for (int i = 1; i <= 5; ++i) {
                for (BlockPos pos : this.waterPos.getOrDefault(i, Collections.emptyList())) {
                    if (((BlockItem)primaryOutput.getItem()).getBlock() != this.colony.getWorld().getBlockState(pos).getBlock()) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean canRecipeBeAdded(@NotNull IToken<?> token) {
            return false;
        }
    }
}

